/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security.authn.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.accounting.security.SecurityManager;

public class SessionFilter
implements Filter {
    private static Logger logger = Logger.getLogger(SessionFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isAuthenticated;
        HttpServletRequest httprequest = (HttpServletRequest)request;
        HttpServletResponse httpresponse = (HttpServletResponse)response;
        if (!SecurityManager.isAuthnEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        if (!"session".equals(SecurityManager.getAuthnType())) {
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httprequest.getSession(false);
        if (httprequest.getRequestURI().endsWith("login.jsp")) {
            chain.doFilter(request, response);
            return;
        }
        if (httprequest.getRequestURI().endsWith("logout.jsp")) {
            logger.debug((Object)"logging out...");
            if (session != null) {
                logger.debug((Object)"invalidating session...");
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    session.invalidate();
                }
            }
            session = httprequest.getSession(true);
            logger.debug((Object)"redirecting to login");
            httpresponse.sendRedirect(httprequest.getContextPath() + "/login.jsp");
            chain.doFilter(request, response);
            return;
        }
        session = httprequest.getSession();
        if (session.getAttribute("userId") != null) {
            logger.debug((Object)"valid session. going ahead.");
            logger.debug(session.getAttribute("userId"));
            request.setAttribute("userId", session.getAttribute("userId"));
            chain.doFilter(request, response);
            return;
        }
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        if (username != null && password != null && (isAuthenticated = SecurityManager.authenticate(username, password))) {
            logger.debug((Object)"authenticated. Going ahead with request");
            session.setAttribute("userId", (Object)username);
            request.setAttribute("userId", (Object)username);
            chain.doFilter(request, response);
            return;
        }
        logger.debug((Object)"redirecting to login...");
        httpresponse.sendRedirect(httprequest.getContextPath() + "/login.jsp");
    }
}

