

package org.gcube.accounting.security.authn.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.gcube.accounting.security.SecurityManager;
import org.gcube.accounting.security.authz.Action;

public class DelegateFilter implements Filter {

	private static Logger logger = Logger.getLogger(DelegateFilter.class);

	@Override
	public void init(FilterConfig arg0) throws ServletException {
	}

	@Override
	public void destroy() {
	}

	@Override
	public void doFilter(ServletRequest req, ServletResponse res,
			FilterChain chain) throws IOException, ServletException {

		HttpServletRequest request = (HttpServletRequest) req;

		/**
		 * Nothing to do if authentication is not enabled
		 */
		if (!SecurityManager.isAuthnEnabled()) {
			logger.debug("Authentication is not enabled. Skipping.");
			chain.doFilter(req, res);
			return;
		}

		/**
		 * Check if a delegatorId identity is provided. If not, do the normal
		 * job.
		 */
		String delegatorId = request.getHeader("delegatorId");
		if (delegatorId == null || delegatorId.trim().equals("")) {
			logger.debug("No delegator id provided. Skipping.");
			chain.doFilter(req, res);
			return;
		}

		/**
		 * Check if userId can act as delegate. If not, do the normal job.
		 */
		String userId = (String) request.getAttribute("userId");
		if (SecurityManager.isAuthzEnabled()
				&& SecurityManager.getAuthorizationManager().isAllowed(userId,
						Action.ACT_AS_DELEGATE)) {
			logger.info(String.format("Replacing userId with delegatorId: %s -> %s", userId, delegatorId));
			request.setAttribute("userId", delegatorId);
		}
		else {
			logger.debug(userId + " can't act as delegate. Skipping.");
		}
		chain.doFilter(req, res);
	}

}
