package org.gcube.accounting.datamodel.adapter;


import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public final class AdapterFilterRatingMap extends

XmlAdapter<MyFilterRatingMapType,Map<String, Double>> {

	@Override
	public MyFilterRatingMapType marshal(Map<String, Double> arg0) throws Exception {
		MyFilterRatingMapType myMapType = new MyFilterRatingMapType();
		for(Entry<String, Double> entry : arg0.entrySet()) {
			MyFilterRatingEntryType myMapEntryType = 
					new MyFilterRatingEntryType();
			myMapEntryType.key = entry.getKey();
			myMapEntryType.value = entry.getValue();
			myMapType.entry.add(myMapEntryType);
		}
		return myMapType;
	}

	@Override
	public Map<String, Double> unmarshal(MyFilterRatingMapType arg0) throws Exception {
		LinkedHashMap<String, Double> hashMap = new LinkedHashMap<String, Double>();
		for(MyFilterRatingEntryType myEntryType : arg0.entry) {
			hashMap.put(myEntryType.key, myEntryType.value);
		}
		return hashMap;
	}

}