/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester.sobigdata;

import eu.trentorise.opendata.jackan.model.CkanGroup;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.Validate;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogueFactory;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogueImpl;
import org.gcube.dataharvest.AccountingDataHarvesterPlugin;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.BasicHarvester;
import org.gcube.dataharvest.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SoBigDataHarvester
extends BasicHarvester {
    private static Logger logger = LoggerFactory.getLogger(SoBigDataHarvester.class);
    private static final String GROUP_LABEL = "group";
    protected HashMap<String, String> mapSystemTypeToDBEntry;
    protected HashMap<String, String> mapCatalogueGroupToVRE;
    protected HashMap<String, String> mapWsFolderNameToVRE;
    private DataCatalogueFactory catalogueFactory = DataCatalogueFactory.getFactory();
    protected SortedSet<String> contexts;

    public SoBigDataHarvester(Date start, Date end, SortedSet<String> contexts) throws Exception {
        super(start, end);
        String currentContext = Utils.getCurrentContext();
        String baseContext = currentContext.substring(0, currentContext.lastIndexOf("/") + 1);
        this.contexts = this.getValidContexts(contexts, baseContext);
        logger.trace("Valid contexts are {}", this.contexts);
        this.initMappingMaps();
    }

    protected void initMappingMaps() throws ObjectNotFound, Exception {
        Properties properties = (Properties)AccountingDataHarvesterPlugin.getProperties().get();
        Set<String> keys = properties.stringPropertyNames();
        this.mapSystemTypeToDBEntry = new HashMap();
        for (String key : keys) {
            try {
                HarvestedDataKey valueEnum = HarvestedDataKey.valueOf(key);
                this.mapSystemTypeToDBEntry.put(properties.getProperty(key), valueEnum.name());
            }
            catch (Exception valueEnum) {}
        }
        logger.info("Built from properties the mapping 'SystemType' to 'DB entry' {}", this.mapSystemTypeToDBEntry);
        String currentContext = Utils.getCurrentContext();
        List<String> groups = this.loadGroupsFromCKAN(currentContext);
        Map<String, String> mapNormalizedGroups = this.normalizeGroups(groups);
        logger.debug("Map of Normalized Groups is {} ", mapNormalizedGroups);
        this.mapCatalogueGroupToVRE = new HashMap();
        this.mapWsFolderNameToVRE = new HashMap();
        Set<String> normalizedGroups = mapNormalizedGroups.keySet();
        for (String context : this.contexts) {
            String loweredVREName = context.substring(context.lastIndexOf("/") + 1, context.length()).toLowerCase();
            try {
                if (normalizedGroups.contains(loweredVREName)) {
                    logger.debug("Normalized Groups matching the lowered VRE name {}", (Object)loweredVREName);
                    this.mapCatalogueGroupToVRE.put(mapNormalizedGroups.get(loweredVREName), context);
                }
                this.mapWsFolderNameToVRE.put(loweredVREName, context);
            }
            catch (Exception exception) {}
        }
        logger.info("Map of Catalogue Groups To VRE is {} ", this.mapCatalogueGroupToVRE);
        logger.info("Map of (lowered) Ws Folder Name To VRE is {}", this.mapWsFolderNameToVRE);
    }

    private Map<String, String> normalizeGroups(List<String> groups) {
        HashMap<String, String> listNGroups = new HashMap<String, String>(groups.size());
        for (String group : groups) {
            String normalizedGroup = group;
            if (normalizedGroup.endsWith(GROUP_LABEL)) {
                normalizedGroup = normalizedGroup.substring(0, normalizedGroup.length() - GROUP_LABEL.length());
            }
            normalizedGroup = normalizedGroup.replaceAll("-", "");
            listNGroups.put(normalizedGroup.toLowerCase(), group);
        }
        return listNGroups;
    }

    private List<String> loadGroupsFromCKAN(String scope) {
        ArrayList<String> groups = new ArrayList<String>();
        String ckanURL = "";
        try {
            DataCatalogueImpl utils = this.catalogueFactory.getUtilsPerScope(scope);
            ckanURL = utils.getCatalogueUrl();
            List theGroups = utils.getGroups();
            Validate.notNull((Object)theGroups, (String)"The list of Groups is null");
            for (CkanGroup ckanGroup : theGroups) {
                groups.add(ckanGroup.getName());
            }
        }
        catch (Exception e) {
            logger.error("Error occurred on getting CKAN groups for scope {} and CKAN URL {}", new Object[]{scope, ckanURL, e});
        }
        return groups;
    }

    public HashMap<String, String> getMapCatalogueGroupToVRE() {
        return this.mapCatalogueGroupToVRE;
    }

    public HashMap<String, String> getMapSystemTypeToDBEntry() {
        return this.mapSystemTypeToDBEntry;
    }

    public HashMap<String, String> getMapWsFolderNameToVRE() {
        return this.mapWsFolderNameToVRE;
    }

    public SortedSet<String> getValidContexts(Set<String> contexts, String base) {
        TreeSet<String> filteredContext = new TreeSet<String>();
        for (String context : contexts) {
            if (!context.startsWith(base)) continue;
            filteredContext.add(context);
        }
        return filteredContext;
    }
}

