/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.java.subdoc.SubdocOperationResult;
import java.util.Collections;
import java.util.List;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class DocumentFragment<OPERATION> {
    private final String id;
    private final long cas;
    private final MutationToken mutationToken;
    private final List<SubdocOperationResult<OPERATION>> resultList;

    public DocumentFragment(String id, long cas, MutationToken mutationToken, List<SubdocOperationResult<OPERATION>> resultList) {
        this.id = id;
        this.cas = cas;
        this.mutationToken = mutationToken;
        this.resultList = resultList == null ? Collections.emptyList() : resultList;
    }

    public String id() {
        return this.id;
    }

    public long cas() {
        return this.cas;
    }

    public MutationToken mutationToken() {
        return this.mutationToken;
    }

    public int size() {
        return this.resultList.size();
    }

    public <T> T content(String path, Class<T> targetClass) {
        if (path == null) {
            return null;
        }
        for (SubdocOperationResult<OPERATION> result : this.resultList) {
            if (!path.equals(result.path())) continue;
            return this.interpretResult(result);
        }
        return null;
    }

    public Object content(String path) {
        return this.content(path, Object.class);
    }

    public <T> T content(int index, Class<T> targetClass) {
        return this.interpretResult(this.resultList.get(index));
    }

    public Object content(int index) {
        return this.content(index, Object.class);
    }

    private <T> T interpretResult(SubdocOperationResult<OPERATION> result) {
        if (result.status() == ResponseStatus.FAILURE && result.value() instanceof RuntimeException) {
            throw (RuntimeException)result.value();
        }
        if (result.value() instanceof CouchbaseException) {
            throw (CouchbaseException)result.value();
        }
        return (T)result.value();
    }

    public ResponseStatus status(String path) {
        if (path == null) {
            return null;
        }
        for (SubdocOperationResult<OPERATION> result : this.resultList) {
            if (!path.equals(result.path())) continue;
            return result.status();
        }
        return null;
    }

    public ResponseStatus status(int index) {
        return this.resultList.get(index).status();
    }

    public boolean exists(String path) {
        if (path == null) {
            return false;
        }
        for (SubdocOperationResult<OPERATION> result : this.resultList) {
            if (!path.equals(result.path()) || result.value() instanceof Exception) continue;
            return true;
        }
        return false;
    }

    public boolean exists(int specIndex) {
        return specIndex >= 0 && specIndex < this.resultList.size() && !(this.resultList.get(specIndex).value() instanceof Exception);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DocumentFragment{").append("id='").append(this.id).append('\'').append(", cas=").append(this.cas).append(", mutationToken=").append(this.mutationToken).append('}');
        if (this.resultList != null && !this.resultList.isEmpty()) {
            sb.append(this.resultList);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFragment that = (DocumentFragment)o;
        if (this.cas != that.cas) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (this.mutationToken != null ? !this.mutationToken.equals((Object)that.mutationToken) : that.mutationToken != null) {
            return false;
        }
        return this.resultList.equals(that.resultList);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (int)(this.cas ^ this.cas >>> 32);
        result = 31 * result + (this.mutationToken != null ? this.mutationToken.hashCode() : 0);
        result = 31 * result + this.resultList.hashCode();
        return result;
    }
}

