/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.google.api.services.analyticsreporting.v4.AnalyticsReporting;
import com.google.api.services.analyticsreporting.v4.AnalyticsReportingScopes;
import com.google.api.services.analyticsreporting.v4.model.DateRange;
import com.google.api.services.analyticsreporting.v4.model.DateRangeValues;
import com.google.api.services.analyticsreporting.v4.model.Dimension;
import com.google.api.services.analyticsreporting.v4.model.GetReportsRequest;
import com.google.api.services.analyticsreporting.v4.model.GetReportsResponse;
import com.google.api.services.analyticsreporting.v4.model.Metric;
import com.google.api.services.analyticsreporting.v4.model.Report;
import com.google.api.services.analyticsreporting.v4.model.ReportRequest;
import com.google.api.services.analyticsreporting.v4.model.ReportRow;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.dataharvest.datamodel.AnalyticsReportCredentials;
import org.gcube.dataharvest.datamodel.CoreServiceAccessesReportRow;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.BasicHarvester;
import org.gcube.dataharvest.utils.Utils;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CoreServicesAccessesHarvester
extends BasicHarvester {
    private static Logger logger = LoggerFactory.getLogger(CoreServicesAccessesHarvester.class);
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final String MAPPING_RESOURCE_CATEGORY = "BigGAnalyticsMapping";
    private static final String SERVICE_ENDPOINT_CATEGORY = "OnlineService";
    private static final String SERVICE_ENDPOINT_NAME = "BigGAnalyticsReportService";
    private static final String AP_VIEWS_PROPERTY = "views";
    private static final String AP_CLIENT_PROPERTY = "clientId";
    private static final String AP_PRIVATEKEY_PROPERTY = "privateKeyId";
    private static final String APPLICATION_NAME = "Analytics Reporting";
    private static final String PAGE_WORKSPACE_ACCESSES = "/workspace";
    private static final String PAGE_MESSAGES_ACCESSES = "/messages";
    private static final String PAGE_PROFILE_ACCESSES = "/profile";
    private static final String PAGE_NOTIFICATION_ACCESSES = "/notifications";
    private HashMap<String, List<CoreServiceAccessesReportRow>> coreServicesAccesses;

    public CoreServicesAccessesHarvester(Date start, Date end) throws Exception {
        super(start, end);
        this.coreServicesAccesses = CoreServicesAccessesHarvester.getAllAccesses(start, end);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        for (String dashboardContext : this.coreServicesAccesses.keySet()) {
            int workspaceAccesses = 0;
            int messagesAccesses = 0;
            int notificationsAccesses = 0;
            int profileAccesses = 0;
            logger.debug("{};", (Object)dashboardContext);
            for (CoreServiceAccessesReportRow row : this.coreServicesAccesses.get(dashboardContext)) {
                switch (row.getKey()) {
                    case WORKSPACE_ACCESSES: {
                        workspaceAccesses += row.getVisitNumber();
                        break;
                    }
                    case MESSAGES_ACCESSES: {
                        messagesAccesses += row.getVisitNumber();
                        break;
                    }
                    case NOTIFICATIONS_ACCESSES: {
                        notificationsAccesses += row.getVisitNumber();
                        break;
                    }
                    case PROFILE_ACCESSES: {
                        profileAccesses += row.getVisitNumber();
                        break;
                    }
                }
            }
            ScopeDescriptor scopeDescriptor = new ScopeDescriptor();
            ScopeBean scopeBean = new ScopeBean(dashboardContext);
            scopeDescriptor.setId(dashboardContext);
            scopeDescriptor.setName(scopeBean.name());
            AccountingRecord ar1 = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.WORKSPACE_ACCESSES), Long.valueOf(workspaceAccesses));
            AccountingRecord ar2 = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.MESSAGES_ACCESSES), Long.valueOf(messagesAccesses));
            AccountingRecord ar3 = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.NOTIFICATIONS_ACCESSES), Long.valueOf(notificationsAccesses));
            AccountingRecord ar4 = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.PROFILE_ACCESSES), Long.valueOf(profileAccesses));
            logger.debug("{};{}", (Object)ar1.getDimension().getId(), (Object)ar1.getMeasure());
            accountingRecords.add(ar1);
            logger.debug("{};{}", (Object)ar2.getDimension().getId(), (Object)ar2.getMeasure());
            accountingRecords.add(ar2);
            logger.debug("{};{}", (Object)ar3.getDimension().getId(), (Object)ar3.getMeasure());
            accountingRecords.add(ar3);
            logger.debug("{};{}", (Object)ar4.getDimension().getId(), (Object)ar4.getMeasure());
            accountingRecords.add(ar4);
        }
        logger.debug("Returning  {} accountingRecords ", (Object)accountingRecords.size());
        return accountingRecords;
    }

    private static HashMap<String, List<CoreServiceAccessesReportRow>> getAllAccesses(Date start, Date end) throws Exception {
        DateRange dateRange = CoreServicesAccessesHarvester.getDateRangeForAnalytics(start, end);
        logger.trace("Getting core services accesses in this time range {}", (Object)dateRange.toPrettyString());
        AnalyticsReportCredentials credentialsFromD4S = CoreServicesAccessesHarvester.getAuthorisedApplicationInfoFromIs();
        logger.trace("gotten credentialsFromD4S id = {}", (Object)credentialsFromD4S.getClientId());
        AnalyticsReporting service = CoreServicesAccessesHarvester.initializeAnalyticsReporting(credentialsFromD4S);
        logger.trace("gotten credentialsFromD4S viewIds= {}", (Object)credentialsFromD4S.getViewIds().toString());
        HashMap<String, List<GetReportsResponse>> responses = CoreServicesAccessesHarvester.getReportResponses(service, credentialsFromD4S.getViewIds(), dateRange);
        HashMap<String, List<CoreServiceAccessesReportRow>> toReturn = new HashMap<String, List<CoreServiceAccessesReportRow>>();
        int i = 1;
        for (String view : responses.keySet()) {
            String dashboardContext = CoreServicesAccessesHarvester.getAccountingDashboardContextGivenGAViewID(view);
            if (dashboardContext != null) {
                logger.trace("\n ({}) ***  Parsing responses for this Gateway view, which corresponds to Dashboard Context: {} \n", (Object)i, (Object)dashboardContext);
                List<CoreServiceAccessesReportRow> viewReport = CoreServicesAccessesHarvester.parseResponse(view, responses.get(view), dashboardContext);
                logger.trace("Got {} entries from view id={}", (Object)viewReport.size(), (Object)view);
                toReturn.put(dashboardContext, viewReport);
            } else {
                logger.warn("Got entries from view id={} but cannot find Dashboard Context correspondance, I think you need to update the Generic Resource of the Mappings", (Object)view);
            }
            ++i;
        }
        return toReturn;
    }

    private static AnalyticsReporting initializeAnalyticsReporting(AnalyticsReportCredentials cred) throws GeneralSecurityException, IOException {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        GoogleCredential credential = CoreServicesAccessesHarvester.fromD4SServiceEndpoint(cred).createScoped((Collection)AnalyticsReportingScopes.all());
        return new AnalyticsReporting.Builder((HttpTransport)httpTransport, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
    }

    private static HashMap<String, List<GetReportsResponse>> getReportResponses(AnalyticsReporting service, List<String> viewIDs, DateRange dateRange) throws IOException {
        HashMap<String, List<GetReportsResponse>> reports = new HashMap<String, List<GetReportsResponse>>();
        Metric sessions = new Metric().setExpression("ga:pageviews").setAlias("pages");
        Dimension pageTitle = new Dimension().setName("ga:pagePath");
        for (String view : viewIDs) {
            ArrayList<GetReportsResponse> gReportResponses = new ArrayList<GetReportsResponse>();
            logger.info("Getting data from Google Analytics for gateway viewid: " + view);
            boolean iterateMorePages = true;
            String nextPageToken = null;
            while (iterateMorePages) {
                ReportRequest request = new ReportRequest().setViewId(view.trim()).setDateRanges(Arrays.asList(dateRange)).setMetrics(Arrays.asList(sessions)).setDimensions(Arrays.asList(pageTitle));
                request.setPageSize(Integer.valueOf(1000));
                request.setPageToken(nextPageToken);
                ArrayList<ReportRequest> requests = new ArrayList<ReportRequest>();
                requests.add(request);
                GetReportsRequest getReport = new GetReportsRequest().setReportRequests(requests);
                GetReportsResponse response = (GetReportsResponse)service.reports().batchGet(getReport).execute();
                nextPageToken = ((Report)response.getReports().get(0)).getNextPageToken();
                iterateMorePages = nextPageToken != null;
                logger.debug("got nextPageToken: " + nextPageToken);
                gReportResponses.add(response);
            }
            reports.put(view, gReportResponses);
        }
        return reports;
    }

    private static List<CoreServiceAccessesReportRow> parseResponse(String viewId, List<GetReportsResponse> responses, String dashboardContext) {
        logger.debug("parsing Response for " + viewId);
        ArrayList<CoreServiceAccessesReportRow> toReturn = new ArrayList<CoreServiceAccessesReportRow>();
        for (GetReportsResponse response : responses) {
            for (Report report : response.getReports()) {
                List rows = report.getData().getRows();
                if (rows == null) {
                    logger.warn("No data found for " + viewId);
                    continue;
                }
                for (ReportRow row : rows) {
                    String dimension = (String)row.getDimensions().get(0);
                    DateRangeValues metric = (DateRangeValues)row.getMetrics().get(0);
                    CoreServiceAccessesReportRow var = new CoreServiceAccessesReportRow();
                    boolean validEntry = false;
                    String pagePath = dimension;
                    logger.trace("parsing pagepath {}: value: {}", (Object)pagePath, (Object)Integer.parseInt((String)metric.getValues().get(0)));
                    if (!pagePath.contains("_redirect=/group")) {
                        if (pagePath.contains(PAGE_WORKSPACE_ACCESSES)) {
                            var.setKey(HarvestedDataKey.WORKSPACE_ACCESSES);
                            logger.trace("**matched " + pagePath);
                            validEntry = true;
                        } else if (pagePath.contains(PAGE_MESSAGES_ACCESSES)) {
                            var.setKey(HarvestedDataKey.MESSAGES_ACCESSES);
                            logger.trace("**matched " + pagePath);
                            validEntry = true;
                        } else if (pagePath.contains(PAGE_PROFILE_ACCESSES)) {
                            var.setKey(HarvestedDataKey.PROFILE_ACCESSES);
                            logger.trace("**matched " + pagePath);
                            validEntry = true;
                        } else if (pagePath.contains(PAGE_NOTIFICATION_ACCESSES)) {
                            var.setKey(HarvestedDataKey.NOTIFICATIONS_ACCESSES);
                            logger.trace("**matched " + pagePath);
                            validEntry = true;
                        }
                    }
                    if (!validEntry) continue;
                    var.setDashboardContext(dashboardContext);
                    var.setPagePath(dimension);
                    var.setVisitNumber(Integer.parseInt((String)metric.getValues().get(0)));
                    toReturn.add(var);
                }
            }
        }
        return toReturn;
    }

    private static GoogleCredential fromD4SServiceEndpoint(AnalyticsReportCredentials cred) throws IOException {
        String clientId = cred.getClientId();
        String clientEmail = cred.getClientEmail();
        String privateKeyPem = cred.getPrivateKeyPem();
        String privateKeyId = cred.getPrivateKeyId();
        String tokenUri = cred.getTokenUri();
        String projectId = cred.getProjectId();
        if (clientId == null || clientEmail == null || privateKeyPem == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from stream, expecting  'client_id', 'client_email', 'private_key' and 'private_key_id'.");
        }
        PrivateKey privateKey = CoreServicesAccessesHarvester.privateKeyFromPkcs8(privateKeyPem);
        List emptyScopes = Collections.emptyList();
        GoogleCredential.Builder credentialBuilder = new GoogleCredential.Builder().setTransport(com.google.api.client.googleapis.util.Utils.getDefaultTransport()).setJsonFactory(com.google.api.client.googleapis.util.Utils.getDefaultJsonFactory()).setServiceAccountId(clientEmail).setServiceAccountScopes(emptyScopes).setServiceAccountPrivateKey(privateKey).setServiceAccountPrivateKeyId(privateKeyId);
        if (tokenUri != null) {
            credentialBuilder.setTokenServerEncodedUrl(tokenUri);
        }
        if (projectId != null) {
            credentialBuilder.setServiceAccountProjectId(projectId);
        }
        return credentialBuilder.build();
    }

    private static PrivateKey privateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem);
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        GeneralSecurityException unexpectedException = null;
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException exception) {
            unexpectedException = exception;
        }
        catch (InvalidKeySpecException exception) {
            unexpectedException = exception;
        }
        throw new IOException("Unexpected exception reading PKCS data", unexpectedException);
    }

    private static List<ServiceEndpoint> getAnalyticsReportingConfigurationFromIS(String infrastructureScope) throws Exception {
        String scope = infrastructureScope;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'OnlineService'");
        query.addCondition("$resource/Profile/Name/text() eq 'BigGAnalyticsReportService'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = client.submit((Query)query);
        ScopeProvider.instance.set(currScope);
        return toReturn;
    }

    private static String getAccountingDashboardContextGivenGAViewID(String viewID) throws ObjectNotFound, Exception {
        String toReturn = null;
        String context = Utils.getCurrentContext();
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(context);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'BigGAnalyticsMapping'");
        query.addCondition("$resource/Profile/Body/Property/viewID/text() eq '" + viewID + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List list = client.submit((Query)query);
        if (list.size() > 1) {
            logger.error("Too many Generic Resources having GA viewID " + viewID + " in this scope having SecondaryType " + MAPPING_RESOURCE_CATEGORY);
        } else if (list.size() == 0) {
            logger.warn("There is no Generic Resources having GA viewID " + viewID + " and SecondaryType " + MAPPING_RESOURCE_CATEGORY + " in this context: " + context);
        } else {
            GenericResource found = (GenericResource)list.get(0);
            String elem = "<body>" + found.profile().bodyAsString() + "</body>";
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
            XPathHelper helper = new XPathHelper((Node)node);
            List currValue = helper.evaluate("//Property/viewID/text()");
            if (currValue != null && currValue.size() > 0) {
                List contexts = currValue;
                for (int i = 0; i < contexts.size(); ++i) {
                    if (((String)currValue.get(i)).trim().compareTo(viewID) != 0) continue;
                    toReturn = (String)helper.evaluate("//Property/DashboardContext/text()").get(i);
                    break;
                }
            }
            logger.debug("Found DashboardContext for viewId {} : {} ", (Object)viewID, toReturn);
        }
        ScopeProvider.instance.set(currScope);
        return toReturn;
    }

    private static AnalyticsReportCredentials getAuthorisedApplicationInfoFromIs() throws Exception {
        AnalyticsReportCredentials reportCredentials = new AnalyticsReportCredentials();
        String context = Utils.getCurrentContext();
        try {
            List<ServiceEndpoint> list = CoreServicesAccessesHarvester.getAnalyticsReportingConfigurationFromIS(context);
            if (list.size() > 1) {
                logger.error("Too many Service Endpoints having name BigGAnalyticsReportService in this scope having Category OnlineService");
            } else if (list.size() == 0) {
                logger.warn("There is no Service Endpoint having name BigGAnalyticsReportService and Category OnlineService in this context: " + context);
            } else {
                for (ServiceEndpoint res : list) {
                    reportCredentials.setTokenUri(res.profile().runtime().hostedOn());
                    Group apGroup = res.profile().accessPoints();
                    ServiceEndpoint.AccessPoint[] accessPoints = (ServiceEndpoint.AccessPoint[])apGroup.toArray((Object[])new ServiceEndpoint.AccessPoint[apGroup.size()]);
                    ServiceEndpoint.AccessPoint found = accessPoints[0];
                    reportCredentials.setClientEmail(found.address());
                    reportCredentials.setProjectId(found.username());
                    reportCredentials.setPrivateKeyPem(StringEncrypter.getEncrypter().decrypt(found.password()));
                    for (ServiceEndpoint.Property prop : found.properties()) {
                        String decryptedValue;
                        if (prop.name().compareTo(AP_VIEWS_PROPERTY) == 0) {
                            decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                            String[] views = decryptedValue.split(";");
                            reportCredentials.setViewIds(Arrays.asList(views));
                        }
                        if (prop.name().compareTo(AP_CLIENT_PROPERTY) == 0) {
                            decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                            reportCredentials.setClientId(decryptedValue);
                        }
                        if (prop.name().compareTo(AP_PRIVATEKEY_PROPERTY) != 0) continue;
                        decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                        reportCredentials.setPrivateKeyId(decryptedValue);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return reportCredentials;
    }

    private static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static DateRange getDateRangeForAnalytics(Date start, Date end) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String startDate = CoreServicesAccessesHarvester.asLocalDate(start).format(formatter);
        String endDate = CoreServicesAccessesHarvester.asLocalDate(end).format(formatter);
        DateRange dateRange = new DateRange();
        dateRange.setStartDate(startDate);
        dateRange.setEndDate(endDate);
        return dateRange;
    }
}

