/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.system.NodeConnectedEvent;
import com.couchbase.client.core.event.system.NodeDisconnectedEvent;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.internal.AddServiceRequest;
import com.couchbase.client.core.message.internal.EndpointHealth;
import com.couchbase.client.core.message.internal.RemoveServiceRequest;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.node.DefaultServiceRegistry;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.ServiceRegistry;
import com.couchbase.client.core.node.ServiceStateZipper;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.ServiceFactory;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.state.AbstractStateMachine;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class CouchbaseNode
extends AbstractStateMachine<LifecycleState>
implements Node {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Node.class);
    private static final long DNS_RESOLUTION_THRESHOLD = TimeUnit.SECONDS.toMillis(1L);
    private final NetworkAddress hostname;
    private final String convertedHostname;
    private final CoreEnvironment environment;
    private final EventBus eventBus;
    private final RingBuffer<ResponseEvent> responseBuffer;
    private final ServiceRegistry serviceRegistry;
    private final ServiceFactory serviceFactory;
    private final ServiceStateZipper serviceStates;
    private volatile boolean connected;
    private volatile int enabledServices;

    public CouchbaseNode(NetworkAddress hostname, CoreEnvironment environment, RingBuffer<ResponseEvent> responseBuffer) {
        this(hostname, new DefaultServiceRegistry(), environment, responseBuffer, ServiceFactory.INSTANCE);
    }

    CouchbaseNode(final NetworkAddress hostname, ServiceRegistry registry, CoreEnvironment environment, RingBuffer<ResponseEvent> responseBuffer, ServiceFactory serviceFactory) {
        super(LifecycleState.DISCONNECTED);
        this.hostname = hostname;
        this.convertedHostname = hostname.nameOrAddress();
        this.serviceRegistry = registry;
        this.environment = environment;
        this.responseBuffer = responseBuffer;
        this.eventBus = environment.eventBus();
        this.serviceFactory = serviceFactory;
        this.serviceStates = new ServiceStateZipper(LifecycleState.DISCONNECTED);
        if (NetworkAddress.ALLOW_REVERSE_DNS) {
            long lookupStart = System.nanoTime();
            String lookupResult = hostname.nameAndAddress();
            long lookupDurationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - lookupStart);
            if (lookupDurationMs >= DNS_RESOLUTION_THRESHOLD) {
                LOGGER.warn("DNS Reverse Lookup of {} is slow, took {}ms", (Object)RedactableArgument.system(lookupResult), (Object)lookupDurationMs);
            }
        }
        this.serviceStates.states().subscribe(new Action1<LifecycleState>(){

            @Override
            public void call(LifecycleState newState) {
                LifecycleState oldState = (LifecycleState)((Object)CouchbaseNode.this.state());
                if (oldState == newState) {
                    return;
                }
                if (newState == LifecycleState.CONNECTED) {
                    if (!CouchbaseNode.this.connected) {
                        CouchbaseNode.this.signalConnected();
                    }
                    CouchbaseNode.this.connected = true;
                    LOGGER.debug("Connected (" + CouchbaseNode.this.state() + ") to Node " + hostname);
                } else if (newState == LifecycleState.DISCONNECTED) {
                    if (CouchbaseNode.this.connected) {
                        CouchbaseNode.this.signalDisconnected();
                    }
                    CouchbaseNode.this.connected = false;
                    LOGGER.debug("Disconnected (" + CouchbaseNode.this.state() + ") from Node " + hostname);
                } else if (newState == LifecycleState.CONNECTING && CouchbaseNode.this.connected) {
                    CouchbaseNode.this.signalDisconnected();
                    CouchbaseNode.this.connected = false;
                    LOGGER.debug("Reconnecting (" + CouchbaseNode.this.state() + ") from Node " + hostname);
                }
                CouchbaseNode.this.transitionState(newState);
            }
        });
    }

    private void signalConnected() {
        LOGGER.info("Connected to Node {}", (Object)RedactableArgument.system(this.hostname.nameAndAddress()));
        if (this.eventBus != null && this.eventBus.hasSubscribers()) {
            this.eventBus.publish(new NodeConnectedEvent(this.hostname));
        }
    }

    private void signalDisconnected() {
        LOGGER.info("Disconnected from Node {}", (Object)RedactableArgument.system(this.hostname.nameAndAddress()));
        if (this.eventBus != null && this.eventBus.hasSubscribers()) {
            this.eventBus.publish(new NodeDisconnectedEvent(this.hostname));
        }
    }

    @Override
    public void send(CouchbaseRequest request) {
        if (request instanceof SignalFlush) {
            for (Service service : this.serviceRegistry.services()) {
                service.send(request);
            }
        } else {
            request.dispatchHostname(this.convertedHostname);
            Service service = this.serviceRegistry.locate(request);
            if (service == null) {
                RetryHelper.retryOrCancel(this.environment, request, this.responseBuffer);
            } else {
                service.send(request);
            }
        }
    }

    @Override
    public NetworkAddress hostname() {
        return this.hostname;
    }

    @Override
    public Observable<LifecycleState> connect() {
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Got instructed to connect.");
        return Observable.from(this.serviceRegistry.services()).flatMap(new Func1<Service, Observable<LifecycleState>>(){

            @Override
            public Observable<LifecycleState> call(Service service) {
                LOGGER.debug(CouchbaseNode.logIdent(CouchbaseNode.this.hostname) + "Instructing Service " + (Object)((Object)service.type()) + " to connect.");
                return service.connect();
            }
        }).toList().map(new Func1<List<LifecycleState>, LifecycleState>(){

            @Override
            public LifecycleState call(List<LifecycleState> state) {
                return (LifecycleState)((Object)CouchbaseNode.this.state());
            }
        });
    }

    @Override
    public Observable<LifecycleState> disconnect() {
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Got instructed to disconnect.");
        return Observable.from(this.serviceRegistry.services()).flatMap(new Func1<Service, Observable<LifecycleState>>(){

            @Override
            public Observable<LifecycleState> call(Service service) {
                LOGGER.debug(CouchbaseNode.logIdent(CouchbaseNode.this.hostname) + "Instructing Service " + (Object)((Object)service.type()) + " to disconnect.");
                return service.disconnect();
            }
        }).toList().map(new Func1<List<LifecycleState>, LifecycleState>(){

            @Override
            public LifecycleState call(List<LifecycleState> state) {
                return (LifecycleState)((Object)CouchbaseNode.this.state());
            }
        });
    }

    @Override
    public Observable<Service> addService(AddServiceRequest request) {
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Adding Service " + (Object)((Object)request.type()));
        Service addedService = this.serviceRegistry.serviceBy(request.type(), request.bucket());
        if (addedService != null) {
            LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Service " + (Object)((Object)request.type()) + " already added, skipping.");
            return Observable.just(addedService);
        }
        final Service service = this.serviceFactory.create(request.hostname().nameOrAddress(), request.bucket(), request.username(), request.password(), request.port(), this.environment, request.type(), this.responseBuffer);
        this.serviceStates.register(service, service);
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Adding Service " + (Object)((Object)request.type()) + " to registry and connecting it.");
        this.serviceRegistry.addService(service, request.bucket());
        this.enabledServices |= 1 << service.type().ordinal();
        return service.connect().map(new Func1<LifecycleState, Service>(){

            @Override
            public Service call(LifecycleState state) {
                return service;
            }
        });
    }

    @Override
    public Observable<Service> removeService(RemoveServiceRequest request) {
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Removing Service " + (Object)((Object)request.type()));
        Service service = this.serviceRegistry.serviceBy(request.type(), request.bucket());
        this.serviceRegistry.removeService(service, request.bucket());
        this.serviceStates.deregister(service);
        this.enabledServices &= ~(1 << service.type().ordinal());
        return Observable.just(service);
    }

    @Override
    public Observable<EndpointHealth> diagnostics() {
        ArrayList<Observable<EndpointHealth>> diags = new ArrayList<Observable<EndpointHealth>>();
        for (Service service : this.serviceRegistry.services()) {
            diags.add(service.diagnostics());
        }
        return Observable.merge(diags);
    }

    public String toString() {
        return "CouchbaseNode{hostname=" + this.hostname + ", services=" + this.serviceRegistry + '}';
    }

    protected static String logIdent(NetworkAddress hostname) {
        return "[" + hostname.nameAndAddress() + "]: ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouchbaseNode that = (CouchbaseNode)o;
        return this.hostname.equals(that.hostname);
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    @Override
    public boolean serviceEnabled(ServiceType type) {
        return (this.enabledServices & 1 << type.ordinal()) != 0;
    }
}

