/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultNodeInfo
implements NodeInfo {
    private final String rawHostname;
    private final NetworkAddress hostname;
    private final Map<ServiceType, Integer> directServices;
    private final Map<ServiceType, Integer> sslServices;
    private final Map<String, AlternateAddress> alternateAddresses;
    private int configPort;
    private volatile String useAlternateNetwork;

    @JsonCreator
    public DefaultNodeInfo(@JsonProperty(value="couchApiBase") String viewUri, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="ports") Map<String, Integer> ports, @JsonProperty(value="alternateAddresses") Map<String, AlternateAddress> alternateAddresses) {
        if (hostname == null) {
            throw new CouchbaseException(new IllegalArgumentException("NodeInfo hostname cannot be null"));
        }
        this.alternateAddresses = alternateAddresses == null ? Collections.emptyMap() : alternateAddresses;
        try {
            this.rawHostname = this.trimPort(hostname);
            this.hostname = NetworkAddress.create(this.rawHostname);
        }
        catch (Exception e) {
            throw new CouchbaseException("Could not analyze hostname from config.", e);
        }
        this.directServices = this.parseDirectServices(viewUri, ports);
        this.sslServices = new HashMap<ServiceType, Integer>();
    }

    public DefaultNodeInfo(NetworkAddress hostname, Map<ServiceType, Integer> direct, Map<ServiceType, Integer> ssl, Map<String, AlternateAddress> alternateAddresses) {
        if (hostname == null) {
            throw new CouchbaseException(new IllegalArgumentException("NodeInfo hostname cannot be null"));
        }
        this.hostname = hostname;
        this.rawHostname = hostname.nameOrAddress();
        this.directServices = direct;
        this.sslServices = ssl;
        this.alternateAddresses = alternateAddresses == null ? Collections.emptyMap() : alternateAddresses;
    }

    @Override
    public NetworkAddress hostname() {
        if (this.useAlternateNetwork != null) {
            AlternateAddress aa = this.alternateAddresses.get(this.useAlternateNetwork);
            if (aa == null) {
                throw new IllegalStateException("external addresses selected, but none found! this is a bug.");
            }
            return aa.hostname();
        }
        return this.hostname;
    }

    @Override
    public Map<ServiceType, Integer> services() {
        if (this.useAlternateNetwork != null) {
            AlternateAddress aa = this.alternateAddresses.get(this.useAlternateNetwork);
            if (aa == null) {
                throw new IllegalStateException("external addresses selected, but none found! this is a bug.");
            }
            return aa.services().isEmpty() ? this.directServices : aa.services();
        }
        return this.directServices;
    }

    @Override
    public Map<ServiceType, Integer> sslServices() {
        if (this.useAlternateNetwork != null) {
            AlternateAddress aa = this.alternateAddresses.get(this.useAlternateNetwork);
            if (aa == null) {
                throw new IllegalStateException("external addresses selected, but none found! this is a bug.");
            }
            return aa.sslServices().isEmpty() ? this.sslServices : aa.sslServices();
        }
        return this.sslServices;
    }

    @Override
    public Map<String, AlternateAddress> alternateAddresses() {
        return this.alternateAddresses;
    }

    private Map<ServiceType, Integer> parseDirectServices(String viewUri, Map<String, Integer> input) {
        HashMap<ServiceType, Integer> services = new HashMap<ServiceType, Integer>();
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            String type = entry.getKey();
            Integer port = entry.getValue();
            if (!type.equals("direct")) continue;
            services.put(ServiceType.BINARY, port);
        }
        services.put(ServiceType.CONFIG, this.configPort);
        if (viewUri != null) {
            services.put(ServiceType.VIEW, URI.create(viewUri).getPort());
        }
        return services;
    }

    private String trimPort(String hostname) {
        String[] parts = hostname.split(":");
        this.configPort = Integer.parseInt(parts[parts.length - 1]);
        if (parts.length > 2) {
            String assembledHost = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                assembledHost = assembledHost + parts[i];
                if (parts[i].endsWith("]")) break;
                assembledHost = assembledHost + ":";
            }
            return assembledHost;
        }
        return parts[0];
    }

    @Override
    public String rawHostname() {
        if (this.useAlternateNetwork != null) {
            AlternateAddress aa = this.alternateAddresses.get(this.useAlternateNetwork);
            if (aa == null) {
                throw new IllegalStateException("external addresses selected, but none found! this is a bug.");
            }
            return aa.rawHostname();
        }
        return this.rawHostname;
    }

    @Override
    public String useAlternateNetwork() {
        return this.useAlternateNetwork;
    }

    @Override
    public void useAlternateNetwork(String useAlternateNetwork) {
        this.useAlternateNetwork = useAlternateNetwork;
    }

    public String toString() {
        return "DefaultNodeInfo{rawHostname='" + this.rawHostname + '\'' + ", hostname=" + this.hostname + ", directServices=" + this.directServices + ", sslServices=" + this.sslServices + ", alternateAddresses=" + this.alternateAddresses + ", configPort=" + this.configPort + ", useAlternateNetwork=" + this.useAlternateNetwork + '}';
    }
}

