/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.env.AbstractServiceConfig;

public final class AnalyticsServiceConfig
extends AbstractServiceConfig {
    private AnalyticsServiceConfig(int minEndpoints, int maxEndpoints, int idleTime) {
        super(minEndpoints, maxEndpoints, false, idleTime);
    }

    public static AnalyticsServiceConfig create(int minEndpoints, int maxEndpoints) {
        return AnalyticsServiceConfig.create(minEndpoints, maxEndpoints, 300);
    }

    public static AnalyticsServiceConfig create(int minEndpoints, int maxEndpoints, int idleTime) {
        if (idleTime > 0 && idleTime < 10) {
            throw new IllegalArgumentException("Idle time must either be 0 (disabled) or greater than 9 seconds");
        }
        return new AnalyticsServiceConfig(minEndpoints, maxEndpoints, idleTime);
    }

    @Override
    public String toString() {
        return "AnalyticsServiceConfig{minEndpoints=" + this.minEndpoints() + ", maxEndpoints=" + this.maxEndpoints() + ", pipelined=" + this.isPipelined() + ", idleTime=" + this.idleTime() + '}';
    }
}

