/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message;

import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.core.tracing.ThresholdLogSpan;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import rx.Subscriber;
import rx.subjects.AsyncSubject;
import rx.subjects.Subject;

public abstract class AbstractCouchbaseRequest
implements CouchbaseRequest {
    private final Subject<CouchbaseResponse, CouchbaseResponse> observable;
    private final String bucket;
    private final String username;
    private final String password;
    private final long creationTime;
    private volatile Subscriber subscriber;
    private volatile int retryCount;
    private volatile long retryAfter;
    private volatile long maxRetryDuration;
    private volatile String dispatchHostname;
    private volatile Span span;
    private volatile Delay retryDelay;
    private volatile String lastLocalSocket;
    private volatile String lastRemoteSocket;
    private volatile String lastLocalId;

    protected AbstractCouchbaseRequest(String bucket, String password) {
        this(bucket, bucket, password, AsyncSubject.create());
    }

    protected AbstractCouchbaseRequest(String bucket, String username, String password) {
        this(bucket, username, password, AsyncSubject.create());
    }

    protected AbstractCouchbaseRequest(String bucket, String username, String password, Subject<CouchbaseResponse, CouchbaseResponse> observable) {
        this.bucket = bucket;
        this.username = username;
        this.password = password;
        this.observable = observable;
        this.creationTime = System.nanoTime();
        this.retryCount = 0;
    }

    @Override
    public Subject<CouchbaseResponse, CouchbaseResponse> observable() {
        return this.observable;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public long creationTime() {
        return this.creationTime;
    }

    @Override
    public int incrementRetryCount() {
        return this.retryCount++;
    }

    @Override
    public int retryCount() {
        return this.retryCount;
    }

    @Override
    public void retryAfter(long after) {
        this.retryAfter = after;
    }

    @Override
    public long retryAfter() {
        return this.retryAfter;
    }

    @Override
    public void maxRetryDuration(long maxRetryDuration) {
        this.maxRetryDuration = maxRetryDuration;
    }

    @Override
    public long maxRetryDuration() {
        return this.maxRetryDuration;
    }

    @Override
    public void retryDelay(Delay retryDelay) {
        this.retryDelay = retryDelay;
    }

    @Override
    public Delay retryDelay() {
        return this.retryDelay;
    }

    @Override
    public boolean isActive() {
        return this.subscriber == null || !this.subscriber.isUnsubscribed();
    }

    @Override
    public void subscriber(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public String dispatchHostname() {
        return this.dispatchHostname;
    }

    @Override
    public void dispatchHostname(String hostname) {
        this.dispatchHostname = hostname;
    }

    @Override
    public void emit(CouchbaseResponse response) {
        this.observable.onNext(response);
    }

    @Override
    public void complete() {
        this.observable.onCompleted();
    }

    @Override
    public void succeed(CouchbaseResponse response) {
        this.emit(response);
        this.complete();
    }

    @Override
    public void fail(Throwable throwable) {
        this.observable.onError(throwable);
        if (this.span != null) {
            HashMap<String, Object> exData = new HashMap<String, Object>();
            exData.put("error.kind", "Exception");
            exData.put("error.object", throwable);
            exData.put("event", "failed");
            exData.put("message", throwable.getMessage());
            this.span.log(exData);
        }
    }

    @Override
    public Span span() {
        return this.span;
    }

    @Override
    public void span(Span span, CoreEnvironment env) {
        this.span = span;
        if (this.span instanceof ThresholdLogSpan) {
            ((ThresholdLogSpan)this.span).request(this);
        }
        this.span.setTag(Tags.DB_TYPE.getKey(), "couchbase");
        this.span.setTag(Tags.SPAN_KIND.getKey(), "client");
        this.span.setTag(Tags.COMPONENT.getKey(), env != null ? env.userAgent() : "couchbase.sdk.java");
        if (this.operationId() != null) {
            this.span.setTag("couchbase.operation_id", this.operationId());
        }
        this.afterSpanSet(this.span);
    }

    @Override
    public String lastLocalSocket() {
        return this.lastLocalSocket;
    }

    @Override
    public String lastRemoteSocket() {
        return this.lastRemoteSocket;
    }

    @Override
    public String lastLocalId() {
        return this.lastLocalId;
    }

    @Override
    public void lastLocalSocket(String local) {
        this.lastLocalSocket = local;
    }

    @Override
    public void lastRemoteSocket(String remote) {
        this.lastRemoteSocket = remote;
    }

    @Override
    public void lastLocalId(String localId) {
        this.lastLocalId = localId;
    }

    protected void afterSpanSet(Span span) {
    }

    @Override
    public String operationId() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append("observable=").append(this.observable);
        sb.append(", bucket='").append(this.bucket).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

