/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.tracing;

import com.couchbase.client.core.BackpressureException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.analytics.AnalyticsRequest;
import com.couchbase.client.core.message.config.ConfigRequest;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.query.GenericQueryRequest;
import com.couchbase.client.core.message.search.SearchRequest;
import com.couchbase.client.core.message.view.ViewRequest;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.tracing.RingBufferDiagnostics;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

@InterfaceAudience.Private
@InterfaceStability.Experimental
public class RingBufferMonitor {
    private final AtomicInteger countKeyValue = new AtomicInteger();
    private final AtomicInteger countQuery = new AtomicInteger();
    private final AtomicInteger countConfig = new AtomicInteger();
    private final AtomicInteger countSearch = new AtomicInteger();
    private final AtomicInteger countView = new AtomicInteger();
    private final AtomicInteger countAnalytics = new AtomicInteger();
    private final AtomicInteger countNonService = new AtomicInteger();
    private static final RingBufferMonitor instance = new RingBufferMonitor();

    public void addRequest(CouchbaseRequest request) {
        AtomicInteger count = this.counterFor(request);
        count.incrementAndGet();
    }

    public void removeRequest(CouchbaseRequest request) {
        AtomicInteger count = this.counterFor(request);
        count.decrementAndGet();
    }

    public void reset() {
        this.countKeyValue.set(0);
        this.countQuery.set(0);
        this.countConfig.set(0);
        this.countSearch.set(0);
        this.countView.set(0);
        this.countAnalytics.set(0);
        this.countNonService.set(0);
    }

    public static RingBufferMonitor instance() {
        return instance;
    }

    private RingBufferMonitor() {
    }

    public BackpressureException createException() {
        HashMap<ServiceType, Integer> counts = new HashMap<ServiceType, Integer>(6);
        counts.put(ServiceType.BINARY, this.countKeyValue.get());
        counts.put(ServiceType.QUERY, this.countQuery.get());
        counts.put(ServiceType.CONFIG, this.countConfig.get());
        counts.put(ServiceType.SEARCH, this.countSearch.get());
        counts.put(ServiceType.VIEW, this.countView.get());
        counts.put(ServiceType.ANALYTICS, this.countAnalytics.get());
        RingBufferDiagnostics diag = new RingBufferDiagnostics(counts, this.countNonService.get());
        return new BackpressureException(diag);
    }

    private AtomicInteger counterFor(CouchbaseRequest request) {
        if (request instanceof GenericQueryRequest) {
            return this.countQuery;
        }
        if (request instanceof ConfigRequest) {
            return this.countConfig;
        }
        if (request instanceof BinaryRequest) {
            return this.countKeyValue;
        }
        if (request instanceof SearchRequest) {
            return this.countSearch;
        }
        if (request instanceof ViewRequest) {
            return this.countView;
        }
        if (request instanceof AnalyticsRequest) {
            return this.countAnalytics;
        }
        return this.countNonService;
    }
}

