/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.ProposedBucketConfigContext;
import com.couchbase.client.core.config.refresher.Refresher;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public abstract class AbstractRefresher
implements Refresher {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Refresher.class);
    private final Subject<ProposedBucketConfigContext, ProposedBucketConfigContext> configStream;
    private final ClusterFacade cluster;
    private volatile ConfigurationProvider provider;
    private final Map<String, Credential> registrations;
    private final CoreEnvironment env;

    protected AbstractRefresher(CoreEnvironment env, ClusterFacade cluster) {
        this.env = env;
        this.configStream = PublishSubject.create().toSerialized();
        this.cluster = cluster;
        this.registrations = new ConcurrentHashMap<String, Credential>();
    }

    @Override
    public Observable<Boolean> deregisterBucket(String name) {
        LOGGER.debug("Deregistering Bucket {} from refresh.", (Object)name);
        if (this.registrations.containsKey(name)) {
            this.registrations.remove(name);
            return Observable.just(true);
        }
        return Observable.just(false);
    }

    @Override
    public Observable<Boolean> registerBucket(String name, String password) {
        return this.registerBucket(name, name, password);
    }

    @Override
    public Observable<Boolean> registerBucket(String name, String username, String password) {
        LOGGER.debug("Registering Bucket {} for refresh.", (Object)name);
        if (this.registrations.containsKey(name)) {
            return Observable.just(false);
        }
        this.registrations.put(name, new Credential(username, password));
        return Observable.just(true);
    }

    @Override
    public Observable<ProposedBucketConfigContext> configs() {
        return this.configStream;
    }

    protected void pushConfig(ProposedBucketConfigContext ctx) {
        try {
            this.configStream.onNext(ctx);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while pushing new configuration - ignoring.", e);
        }
    }

    protected ClusterFacade cluster() {
        return this.cluster;
    }

    protected ConfigurationProvider provider() {
        return this.provider;
    }

    @Override
    public void provider(ConfigurationProvider provider) {
        this.provider = provider;
    }

    protected Map<String, Credential> registrations() {
        return this.registrations;
    }

    static class Credential {
        private final String username;
        private final String password;

        public Credential(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }
    }
}

