/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.internal;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.internal.DiagnosticsReport;
import com.couchbase.client.core.message.internal.PingServiceHealth;
import com.couchbase.client.core.utils.DefaultObjectMapper;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class PingReport {
    private final List<PingServiceHealth> services;
    private final String sdk;
    private final String id;
    private final int version;
    private final long configRev;

    public PingReport(List<PingServiceHealth> services, String sdk, String id, long configRev) {
        this.services = services;
        this.version = 1;
        this.sdk = sdk;
        this.configRev = configRev;
        this.id = id == null ? UUID.randomUUID().toString() : id;
    }

    public List<PingServiceHealth> services() {
        return this.services;
    }

    public String exportToJson() {
        return this.exportToJson(false);
    }

    public String exportToJson(boolean pretty) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap services = new HashMap();
        for (PingServiceHealth h : this.services) {
            String type = DiagnosticsReport.serviceTypeFromEnum(h.type());
            if (!services.containsKey(type)) {
                services.put(type, new ArrayList());
            }
            List eps = (List)services.get(type);
            eps.add(h.toMap());
        }
        result.put("config_rev", this.configRev);
        result.put("version", this.version);
        result.put("services", services);
        result.put("sdk", this.sdk);
        result.put("id", this.id);
        try {
            if (pretty) {
                return DefaultObjectMapper.prettyWriter().writeValueAsString(result);
            }
            return DefaultObjectMapper.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not encode as JSON string.", e);
        }
    }

    public String sdk() {
        return this.sdk;
    }

    public String id() {
        return this.id;
    }

    public int version() {
        return this.version;
    }

    public long configRev() {
        return this.configRev;
    }

    public String toString() {
        return "PingReport{services=" + this.services + '}';
    }
}

