/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.system.NodeConnectedEvent;
import com.couchbase.client.core.event.system.NodeDisconnectedEvent;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.internal.AddServiceRequest;
import com.couchbase.client.core.message.internal.EndpointHealth;
import com.couchbase.client.core.message.internal.RemoveServiceRequest;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.node.DefaultServiceRegistry;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.ServiceRegistry;
import com.couchbase.client.core.node.ServiceStateZipper;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.ServiceFactory;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.state.AbstractStateMachine;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class CouchbaseNode
extends AbstractStateMachine<LifecycleState>
implements Node {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Node.class);
    private final String hostname;
    private final String alternate;
    private final CoreEnvironment environment;
    private final EventBus eventBus;
    private final RingBuffer<ResponseEvent> responseBuffer;
    private final ServiceRegistry serviceRegistry;
    private final ServiceFactory serviceFactory;
    private final ServiceStateZipper serviceStates;
    private final CoreContext ctx;
    private volatile boolean connected;
    private volatile int enabledServices;

    public CouchbaseNode(String hostname, CoreContext ctx) {
        this(hostname, new DefaultServiceRegistry(), ctx, ServiceFactory.INSTANCE, null);
    }

    public CouchbaseNode(String hostname, CoreContext ctx, String alternate) {
        this(hostname, new DefaultServiceRegistry(), ctx, ServiceFactory.INSTANCE, alternate);
    }

    CouchbaseNode(String hostname, ServiceRegistry registry, CoreContext ctx, ServiceFactory serviceFactory) {
        this(hostname, registry, ctx, serviceFactory, null);
    }

    CouchbaseNode(String hostname, ServiceRegistry registry, CoreContext ctx, ServiceFactory serviceFactory, String alternate) {
        super(LifecycleState.DISCONNECTED);
        this.hostname = hostname;
        this.alternate = alternate;
        this.serviceRegistry = registry;
        this.environment = ctx.environment();
        this.responseBuffer = ctx.responseRingBuffer();
        this.ctx = ctx;
        this.eventBus = this.environment.eventBus();
        this.serviceFactory = serviceFactory;
        this.serviceStates = new ServiceStateZipper(LifecycleState.DISCONNECTED);
        this.serviceStates.states().subscribe(new Action1<LifecycleState>(){

            @Override
            public void call(LifecycleState newState) {
                LifecycleState oldState = (LifecycleState)((Object)CouchbaseNode.this.state());
                if (oldState == newState) {
                    return;
                }
                if (newState == LifecycleState.CONNECTED) {
                    if (!CouchbaseNode.this.connected) {
                        CouchbaseNode.this.signalConnected();
                    }
                    CouchbaseNode.this.connected = true;
                    LOGGER.debug(CouchbaseNode.this.logIdent() + "Connected (" + CouchbaseNode.this.state() + ") to Node");
                } else if (newState == LifecycleState.DISCONNECTED) {
                    if (CouchbaseNode.this.connected) {
                        CouchbaseNode.this.signalDisconnected();
                    }
                    CouchbaseNode.this.connected = false;
                    LOGGER.debug(CouchbaseNode.this.logIdent() + "Disconnected (" + CouchbaseNode.this.state() + ") from Node");
                } else if (newState == LifecycleState.CONNECTING && CouchbaseNode.this.connected) {
                    CouchbaseNode.this.signalDisconnected();
                    CouchbaseNode.this.connected = false;
                    LOGGER.debug(CouchbaseNode.this.logIdent() + "Reconnecting (" + CouchbaseNode.this.state() + ") from Node");
                }
                CouchbaseNode.this.transitionState(newState);
            }
        });
    }

    private void signalConnected() {
        if (this.alternate != null) {
            LOGGER.info("Connected to Node {} ({})", (Object)RedactableArgument.system(this.hostname), (Object)RedactableArgument.system(this.alternate));
        } else {
            LOGGER.info("Connected to Node {}", (Object)RedactableArgument.system(this.hostname));
        }
        if (this.eventBus != null && this.eventBus.hasSubscribers()) {
            this.eventBus.publish(new NodeConnectedEvent(this.hostname));
        }
    }

    private void signalDisconnected() {
        if (this.alternate != null) {
            LOGGER.info("Disconnected from Node {} ({})", (Object)RedactableArgument.system(this.hostname), (Object)RedactableArgument.system(this.alternate));
        } else {
            LOGGER.info("Disconnected from Node {}", (Object)RedactableArgument.system(this.hostname));
        }
        if (this.eventBus != null && this.eventBus.hasSubscribers()) {
            this.eventBus.publish(new NodeDisconnectedEvent(this.hostname));
        }
    }

    @Override
    public void send(CouchbaseRequest request) {
        if (request instanceof SignalFlush) {
            for (Service service : this.serviceRegistry.services()) {
                service.send(request);
            }
        } else {
            request.dispatchHostname(this.hostname);
            Service service = this.serviceRegistry.locate(request);
            if (service == null) {
                RetryHelper.retryOrCancel(this.environment, request, this.responseBuffer);
            } else {
                service.send(request);
            }
        }
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public Observable<LifecycleState> connect() {
        LOGGER.debug(this.logIdent() + "Got instructed to connect.");
        return Observable.from(this.serviceRegistry.services()).flatMap(new Func1<Service, Observable<LifecycleState>>(){

            @Override
            public Observable<LifecycleState> call(Service service) {
                LOGGER.debug(CouchbaseNode.this.logIdent() + "Instructing Service " + (Object)((Object)service.type()) + " to connect.");
                return service.connect();
            }
        }).toList().map(new Func1<List<LifecycleState>, LifecycleState>(){

            @Override
            public LifecycleState call(List<LifecycleState> state) {
                return (LifecycleState)((Object)CouchbaseNode.this.state());
            }
        });
    }

    @Override
    public Observable<LifecycleState> disconnect() {
        LOGGER.debug(this.logIdent() + "Got instructed to disconnect.");
        return Observable.from(this.serviceRegistry.services()).flatMap(new Func1<Service, Observable<LifecycleState>>(){

            @Override
            public Observable<LifecycleState> call(Service service) {
                LOGGER.debug(CouchbaseNode.this.logIdent() + "Instructing Service " + (Object)((Object)service.type()) + " to disconnect.");
                return service.disconnect();
            }
        }).toList().map(new Func1<List<LifecycleState>, LifecycleState>(){

            @Override
            public LifecycleState call(List<LifecycleState> state) {
                return (LifecycleState)((Object)CouchbaseNode.this.state());
            }
        });
    }

    @Override
    public Observable<Service> addService(AddServiceRequest request) {
        String hostname;
        LOGGER.debug(this.logIdent() + "Adding Service " + (Object)((Object)request.type()));
        Service addedService = this.serviceRegistry.serviceBy(request.type(), request.bucket());
        if (addedService != null) {
            LOGGER.debug(this.logIdent() + "Service " + (Object)((Object)request.type()) + " already added, skipping.");
            return Observable.just(addedService);
        }
        String string = hostname = this.alternate != null ? this.alternate : this.hostname;
        if (this.alternate != null) {
            LOGGER.debug(this.logIdent() + "Service {} is mapped to alternate hostname {}", (Object)request.type(), (Object)hostname);
        }
        final Service service = this.serviceFactory.create(hostname, request.bucket(), request.username(), request.password(), request.port(), this.ctx, request.type());
        this.serviceStates.register(service, service);
        LOGGER.debug(this.logIdent() + "Adding Service " + (Object)((Object)request.type()) + " to registry and connecting it.");
        this.serviceRegistry.addService(service, request.bucket());
        this.enabledServices |= 1 << service.type().ordinal();
        return service.connect().map(new Func1<LifecycleState, Service>(){

            @Override
            public Service call(LifecycleState state) {
                return service;
            }
        });
    }

    @Override
    public Observable<Service> removeService(RemoveServiceRequest request) {
        LOGGER.debug(this.logIdent() + "Removing Service " + (Object)((Object)request.type()));
        final Service service = this.serviceRegistry.serviceBy(request.type(), request.bucket());
        this.serviceRegistry.removeService(service, request.bucket());
        this.serviceStates.deregister(service);
        this.enabledServices &= ~(1 << service.type().ordinal());
        return service.disconnect().map(new Func1<LifecycleState, Service>(){

            @Override
            public Service call(LifecycleState lifecycleState) {
                return service;
            }
        });
    }

    @Override
    public Observable<EndpointHealth> diagnostics() {
        ArrayList<Observable<EndpointHealth>> diags = new ArrayList<Observable<EndpointHealth>>();
        for (Service service : this.serviceRegistry.services()) {
            diags.add(service.diagnostics());
        }
        return Observable.merge(diags);
    }

    public String toString() {
        return "CouchbaseNode{hostname=" + this.hostname + ", services=" + this.serviceRegistry + '}';
    }

    private String logIdent() {
        if (this.alternate != null) {
            return "[" + this.hostname + " (" + this.alternate + ")]: ";
        }
        return "[" + this.hostname + "]: ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouchbaseNode that = (CouchbaseNode)o;
        return this.hostname.equals(that.hostname);
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    @Override
    public boolean serviceEnabled(ServiceType type) {
        return (this.enabledServices & 1 << type.ordinal()) != 0;
    }
}

