/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.internal;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.core.utils.NetworkAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class EndpointHealth {
    private final ServiceType type;
    private final LifecycleState state;
    private final InetSocketAddress local;
    private final InetSocketAddress remote;
    private final long lastActivityUs;
    private final long pingLatencyUs;

    public EndpointHealth(ServiceType type, LifecycleState state, SocketAddress localAddr, SocketAddress remoteAddr, long lastActivityUs, long pingLatencyUs) {
        this.type = type;
        this.state = state;
        if (!(localAddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Right now only InetSocketAddress is supported");
        }
        if (!(remoteAddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Right now only InetSocketAddress is supported");
        }
        this.local = (InetSocketAddress)localAddr;
        this.remote = (InetSocketAddress)remoteAddr;
        this.lastActivityUs = lastActivityUs;
        this.pingLatencyUs = pingLatencyUs;
    }

    public ServiceType type() {
        return this.type;
    }

    public LifecycleState state() {
        return this.state;
    }

    public InetSocketAddress local() {
        return this.local;
    }

    public InetSocketAddress remote() {
        return this.remote;
    }

    public long lastActivity() {
        return this.lastActivityUs;
    }

    public long pingLatency() {
        return this.pingLatencyUs;
    }

    public Map<String, Object> toMap() {
        NetworkAddress ra = NetworkAddress.create(this.remote().getAddress().getHostAddress());
        NetworkAddress la = NetworkAddress.create(this.local().getAddress().getHostAddress());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("remote", this.remote() == null ? "" : ra.nameOrAddress() + ":" + this.remote().getPort());
        map.put("local", this.local() == null ? "" : la.nameOrAddress() + ":" + this.local().getPort());
        map.put("state", this.state().toString().toLowerCase());
        map.put("last_activity_us", this.lastActivity());
        map.put("latency_us", this.pingLatency());
        return map;
    }

    public String toString() {
        return "EndpointHealth{type=" + (Object)((Object)this.type) + ", state=" + (Object)((Object)this.state) + ", local=" + this.local + ", remote=" + this.remote + ", lastActivity=" + this.lastActivityUs + '}';
    }
}

