/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.state;

import com.couchbase.client.core.state.AbstractStateMachine;
import com.couchbase.client.core.state.StateZipper;
import com.couchbase.client.core.state.Stateful;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Subscriber;
import rx.Subscription;

public abstract class AbstractStateZipper<T, S extends Enum>
extends AbstractStateMachine<S>
implements StateZipper<T, S> {
    private final Map<T, Subscription> subscriptions;
    private final Map<T, S> states;
    private final S initialState;

    protected AbstractStateZipper(S initialState) {
        super(initialState);
        this.initialState = initialState;
        this.subscriptions = new ConcurrentHashMap<T, Subscription>();
        this.states = new ConcurrentHashMap<T, S>();
    }

    protected abstract S zipWith(Collection<S> var1);

    @Override
    public void register(final T identifier, Stateful<S> upstream) {
        Subscription subscription = upstream.states().subscribe(new Subscriber<S>(){

            @Override
            public void onCompleted() {
                AbstractStateZipper.this.deregister(identifier);
            }

            @Override
            public void onError(Throwable error) {
                AbstractStateZipper.this.deregister(identifier);
            }

            @Override
            public void onNext(S state) {
                AbstractStateZipper.this.states.put(identifier, state);
                AbstractStateZipper.this.transitionStateThroughZipper();
            }
        });
        this.subscriptions.put(identifier, subscription);
    }

    @Override
    public void deregister(T identifier) {
        if (identifier == null) {
            return;
        }
        Subscription subscription = this.subscriptions.get(identifier);
        if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
            this.subscriptions.remove(identifier);
            this.states.remove(identifier);
            this.transitionStateThroughZipper();
        }
    }

    @Override
    public void terminate() {
        Iterator<T> iterator = this.subscriptions.keySet().iterator();
        while (iterator.hasNext()) {
            T identifier = iterator.next();
            Subscription subscription = this.subscriptions.get(identifier);
            if (subscription == null || subscription.isUnsubscribed()) continue;
            subscription.unsubscribe();
            iterator.remove();
            this.states.remove(identifier);
        }
        this.transitionStateThroughZipper();
    }

    private void transitionStateThroughZipper() {
        Collection<S> currentStates = this.states.values();
        if (currentStates.isEmpty()) {
            this.transitionState(this.initialState);
        } else {
            this.transitionState(this.zipWith(currentStates));
        }
    }

    protected Map<T, Subscription> currentSubscriptions() {
        return this.subscriptions;
    }

    protected Map<T, S> currentStates() {
        return this.states;
    }
}

