/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import javax.security.auth.Subject;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.core.ContentSessionImpl;
import org.apache.jackrabbit.oak.core.MutableRoot;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.query.CompositeQueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.OpenSecurityProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContext;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class SystemRoot
extends MutableRoot {
    private static final LoginContext LOGIN_CONTEXT = new LoginContext(){

        @Override
        public Subject getSubject() {
            return SystemSubject.INSTANCE;
        }

        @Override
        public void login() {
        }

        @Override
        public void logout() {
        }
    };

    private SystemRoot(NodeStore store, CommitHook hook, String workspaceName, SecurityProvider securityProvider, QueryEngineSettings queryEngineSettings, QueryIndexProvider indexProvider, ContentSessionImpl session) {
        super(store, hook, workspaceName, SystemSubject.INSTANCE, securityProvider, queryEngineSettings, indexProvider, session);
    }

    public SystemRoot(final NodeStore store, final CommitHook hook, final String workspaceName, final SecurityProvider securityProvider, final QueryEngineSettings queryEngineSettings, final QueryIndexProvider indexProvider) {
        this(store, hook, workspaceName, securityProvider, queryEngineSettings, indexProvider, new ContentSessionImpl(LOGIN_CONTEXT, securityProvider, workspaceName, store, hook, queryEngineSettings, indexProvider){

            @Override
            public Root getLatestRoot() {
                return new SystemRoot(store, hook, workspaceName, securityProvider, queryEngineSettings, indexProvider, this);
            }
        });
    }

    public SystemRoot(NodeStore store) {
        this(store, EmptyHook.INSTANCE);
    }

    public SystemRoot(NodeStore store, CommitHook hook) {
        this(store, hook, "default", new OpenSecurityProvider(), new QueryEngineSettings(), new CompositeQueryIndexProvider(new QueryIndexProvider[0]));
    }
}

