/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.commons.xml.DocumentViewExporter;
import org.apache.jackrabbit.commons.xml.Exporter;
import org.apache.jackrabbit.commons.xml.ParsingContentHandler;
import org.apache.jackrabbit.commons.xml.SystemViewExporter;
import org.apache.jackrabbit.commons.xml.ToXmlContentHandler;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.security.AccessManager;
import org.apache.jackrabbit.oak.jcr.session.ItemImpl;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.PropertyImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.xml.ImportHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SessionImpl
implements JackrabbitSession {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private final SessionContext sessionContext;
    private final SessionDelegate sd;
    private final AtomicLong sessionCounter;

    public SessionImpl(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.sd = sessionContext.getSessionDelegate();
        this.sessionCounter = sessionContext.getCounter(RepositoryStatistics.Type.SESSION_COUNT);
        this.sessionCounter.incrementAndGet();
        sessionContext.getCounter(RepositoryStatistics.Type.SESSION_LOGIN_COUNTER).incrementAndGet();
    }

    static void checkIndexOnName(SessionContext sessionContext, String path) throws RepositoryException {
        String oakPath = sessionContext.getOakPathKeepIndex(path);
        if (oakPath != null && PathUtils.getName(oakPath).contains("[")) {
            throw new RepositoryException("Cannot create a new node using a name including an index");
        }
    }

    @CheckForNull
    private <T> T perform(@Nonnull SessionOperation<T> op) throws RepositoryException {
        return this.sd.perform(op);
    }

    @CheckForNull
    private <T> T safePerform(@Nonnull SessionOperation<T> op) {
        return this.sd.safePerform(op);
    }

    @Nonnull
    private String getOakPathOrThrow(String absPath) throws RepositoryException {
        String p = this.sessionContext.getOakPathOrThrow(absPath);
        if (!PathUtils.isAbsolute(p)) {
            throw new RepositoryException("Not an absolute path: " + absPath);
        }
        return p;
    }

    @Nonnull
    private String getOakPathOrThrowNotFound(String absPath) throws PathNotFoundException {
        return this.sessionContext.getOakPathOrThrowNotFound(absPath);
    }

    @CheckForNull
    private ItemImpl<?> getItemInternal(@Nonnull String oakPath) throws RepositoryException {
        ItemDelegate item = this.sd.getItem(oakPath);
        if (item instanceof NodeDelegate) {
            return NodeImpl.createNodeOrNull((NodeDelegate)item, this.sessionContext);
        }
        if (item instanceof PropertyDelegate) {
            return new PropertyImpl((PropertyDelegate)item, this.sessionContext);
        }
        return null;
    }

    @Override
    @CheckForNull
    public Node getNodeOrNull(final String absPath) throws RepositoryException {
        return this.perform(new ReadOperation<Node>("getNodeOrNull"){

            @Override
            public Node perform() throws RepositoryException {
                try {
                    return NodeImpl.createNodeOrNull(SessionImpl.this.sd.getNode(SessionImpl.this.getOakPathOrThrow(absPath)), SessionImpl.this.sessionContext);
                }
                catch (PathNotFoundException e) {
                    return null;
                }
            }
        });
    }

    @Override
    @CheckForNull
    public Property getPropertyOrNull(String absPath) throws RepositoryException {
        String oakPath;
        if (absPath.equals("/")) {
            return null;
        }
        try {
            oakPath = this.getOakPathOrThrow(absPath);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        return this.perform(new ReadOperation<Property>("getPropertyOrNull"){

            @Override
            public Property perform() throws RepositoryException {
                PropertyDelegate pd = SessionImpl.this.sd.getProperty(oakPath);
                if (pd != null) {
                    return new PropertyImpl(pd, SessionImpl.this.sessionContext);
                }
                return null;
            }
        });
    }

    @Override
    @CheckForNull
    public Item getItemOrNull(final String absPath) throws RepositoryException {
        return this.perform(new ReadOperation<Item>("getItemOrNull"){

            @Override
            public Item perform() throws RepositoryException {
                return SessionImpl.this.getItemInternal(SessionImpl.this.getOakPathOrThrow(absPath));
            }
        });
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.sessionContext.getRepository();
    }

    @Override
    public String getUserID() {
        return this.sd.getAuthInfo().getUserID();
    }

    @Override
    public String[] getAttributeNames() {
        TreeSet<String> names = Sets.newTreeSet(this.sessionContext.getAttributes().keySet());
        Collections.addAll(names, this.sd.getAuthInfo().getAttributeNames());
        return names.toArray(new String[names.size()]);
    }

    @Override
    public Object getAttribute(String name) {
        Object attribute = this.sd.getAuthInfo().getAttribute(name);
        if (attribute == null) {
            attribute = this.sessionContext.getAttributes().get(name);
        }
        return attribute;
    }

    @Override
    @Nonnull
    public Workspace getWorkspace() {
        return this.sessionContext.getWorkspace();
    }

    @Override
    @Nonnull
    public Session impersonate(Credentials credentials) throws RepositoryException {
        this.sd.checkAlive();
        ImpersonationCredentials impCreds = new ImpersonationCredentials(credentials, this.sd.getAuthInfo());
        return this.getRepository().login(impCreds, this.sd.getWorkspaceName());
    }

    @Override
    @Nonnull
    public ValueFactory getValueFactory() throws RepositoryException {
        this.sd.checkAlive();
        return this.sessionContext.getValueFactory();
    }

    @Override
    @Nonnull
    public Node getRootNode() throws RepositoryException {
        return this.perform(new ReadOperation<Node>("getRootNode"){

            @Override
            public Node perform() throws RepositoryException {
                NodeDelegate nd = SessionImpl.this.sd.getRootNode();
                if (nd == null) {
                    throw new AccessDeniedException("Root node is not accessible.");
                }
                return NodeImpl.createNodeOrNull(nd, SessionImpl.this.sessionContext);
            }
        });
    }

    @Override
    public Node getNode(String absPath) throws RepositoryException {
        Node node = this.getNodeOrNull(absPath);
        if (node == null) {
            throw new PathNotFoundException("Node with path " + absPath + " does not exist.");
        }
        return node;
    }

    @Override
    public boolean nodeExists(String absPath) throws RepositoryException {
        return this.getNodeOrNull(absPath) != null;
    }

    @Nonnull
    private Node getNodeById(final String id) throws RepositoryException {
        return this.perform(new ReadOperation<Node>("getNodeById"){

            @Override
            public Node perform() throws RepositoryException {
                NodeDelegate nd = SessionImpl.this.sd.getNodeByIdentifier(id);
                if (nd == null) {
                    throw new ItemNotFoundException("Node with id " + id + " does not exist.");
                }
                return NodeImpl.createNodeOrNull(nd, SessionImpl.this.sessionContext);
            }
        });
    }

    @Override
    @Nonnull
    public Node getNodeByUUID(String uuid) throws RepositoryException {
        return this.getNodeById(uuid);
    }

    @Override
    @Nonnull
    public Node getNodeByIdentifier(String id) throws RepositoryException {
        return this.getNodeById(id);
    }

    @Override
    public Property getProperty(String absPath) throws RepositoryException {
        Property property = this.getPropertyOrNull(absPath);
        if (property == null) {
            throw new PathNotFoundException(absPath);
        }
        return property;
    }

    @Override
    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.getPropertyOrNull(absPath) != null;
    }

    @Override
    public Item getItem(String absPath) throws RepositoryException {
        Item item = this.getItemOrNull(absPath);
        if (item == null) {
            throw new PathNotFoundException(absPath);
        }
        return item;
    }

    @Override
    public boolean itemExists(String absPath) throws RepositoryException {
        return this.getItemOrNull(absPath) != null;
    }

    @Override
    public void move(String srcAbsPath, String destAbsPath) throws RepositoryException {
        SessionImpl.checkIndexOnName(this.sessionContext, destAbsPath);
        final String srcOakPath = this.getOakPathOrThrowNotFound(srcAbsPath);
        final String destOakPath = this.getOakPathOrThrowNotFound(destAbsPath);
        this.sd.perform(new WriteOperation<Void>("move"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                SessionImpl.this.sd.checkProtectedNode(PathUtils.getParentPath(srcOakPath));
                SessionImpl.this.sd.checkProtectedNode(PathUtils.getParentPath(destOakPath));
            }

            @Override
            public Void perform() throws RepositoryException {
                SessionImpl.this.sd.move(srcOakPath, destOakPath, true);
                return null;
            }
        });
    }

    @Override
    public void removeItem(final String absPath) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrowNotFound(absPath);
        this.perform(new WriteOperation<Void>("removeItem"){

            @Override
            public Void perform() throws RepositoryException {
                ItemDelegate item = SessionImpl.this.sd.getItem(oakPath);
                if (item == null) {
                    throw new PathNotFoundException(absPath);
                }
                if (item.isProtected()) {
                    throw new ConstraintViolationException(item.getPath() + " is protected");
                }
                if (item.remove()) {
                    return null;
                }
                throw new RepositoryException(item.getPath() + " could not be removed");
            }
        });
    }

    @Override
    public void save() throws RepositoryException {
        this.perform(new WriteOperation<Void>("save"){

            @Override
            public Void perform() throws RepositoryException {
                SessionImpl.this.sd.save(null);
                return null;
            }

            @Override
            public boolean isSave() {
                return true;
            }
        });
    }

    @Override
    public void refresh(final boolean keepChanges) throws RepositoryException {
        this.perform(new WriteOperation<Void>("refresh"){

            @Override
            public Void perform() {
                SessionImpl.this.sd.refresh(keepChanges);
                return null;
            }

            @Override
            public boolean isRefresh() {
                return true;
            }
        });
    }

    @Override
    public boolean hasPendingChanges() throws RepositoryException {
        this.sd.checkAlive();
        return this.sd.hasPendingChanges();
    }

    @Override
    public boolean isLive() {
        return this.sd.isAlive();
    }

    @Override
    public void logout() {
        if (this.sd.isAlive()) {
            this.sessionCounter.decrementAndGet();
            this.safePerform(new SessionOperation<Void>("logout"){

                @Override
                public Void perform() {
                    SessionImpl.this.sessionContext.dispose();
                    SessionImpl.this.sd.logout();
                    return null;
                }

                @Override
                public boolean isLogout() {
                    return true;
                }
            });
        }
    }

    @Override
    @Nonnull
    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws RepositoryException {
        return new ImportHandler(parentAbsPath, this.sessionContext, uuidBehavior, false);
    }

    @Override
    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, RepositoryException {
        try {
            ContentHandler handler = this.getImportContentHandler(parentAbsPath, uuidBehavior);
            new ParsingContentHandler(handler).parse(in);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new InvalidSerializedDataException("XML parse error", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private synchronized void export(String path, Exporter exporter) throws SAXException, RepositoryException {
        Item item = this.getItem(path);
        if (!item.isNode()) {
            throw new PathNotFoundException("XML export is not defined for properties: " + path);
        }
        exporter.export((Node)item);
    }

    @Override
    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
        this.export(absPath, new SystemViewExporter(this, contentHandler, !noRecurse, !skipBinary));
    }

    @Override
    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ToXmlContentHandler handler = new ToXmlContentHandler(out);
            this.export(absPath, new SystemViewExporter(this, handler, !noRecurse, !skipBinary));
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing system view XML", e);
        }
    }

    @Override
    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
        this.export(absPath, new DocumentViewExporter(this, contentHandler, !noRecurse, !skipBinary));
    }

    @Override
    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ToXmlContentHandler handler = new ToXmlContentHandler(out);
            this.export(absPath, new DocumentViewExporter(this, handler, !noRecurse, !skipBinary));
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing document view XML", e);
        }
    }

    @Override
    public void addLockToken(String lt) {
        try {
            this.getWorkspace().getLockManager().addLockToken(lt);
        }
        catch (RepositoryException e) {
            log.warn("Unable to add lock token " + lt + " to session", (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public String[] getLockTokens() {
        try {
            return this.getWorkspace().getLockManager().getLockTokens();
        }
        catch (RepositoryException e) {
            log.warn("Unable to retrieve lock tokens from session", (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public void removeLockToken(String lt) {
        try {
            this.getWorkspace().getLockManager().removeLockToken(lt);
        }
        catch (RepositoryException e) {
            log.warn("Unable to remove lock token " + lt + " from session", (Throwable)e);
        }
    }

    @Override
    public boolean hasPermission(String absPath, final String actions) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrow(absPath);
        return this.perform(new ReadOperation<Boolean>("hasPermission"){

            @Override
            public Boolean perform() throws RepositoryException {
                return SessionImpl.this.sessionContext.getAccessManager().hasPermissions(oakPath, actions);
            }
        });
    }

    @Override
    public void checkPermission(String absPath, String actions) throws RepositoryException {
        if (!this.hasPermission(absPath, actions)) {
            throw new AccessControlException("Access denied.");
        }
    }

    @Override
    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        this.sd.checkAlive();
        if (target instanceof ItemImpl) {
            Node parent;
            Object dlg = ((ItemImpl)target).dlg;
            if (((ItemDelegate)dlg).isProtected()) {
                return false;
            }
            boolean isNode = ((ItemImpl)target).isNode();
            Node node = parent = isNode ? (Node)target : ((ItemImpl)target).getParent();
            if (!parent.isCheckedOut()) {
                return false;
            }
            if (parent.isLocked()) {
                return false;
            }
            AccessManager accessMgr = this.sessionContext.getAccessManager();
            long permission = 0L;
            if (isNode) {
                Tree tree = ((NodeDelegate)dlg).getTree();
                if ("addNode".equals(methodName)) {
                    if (arguments != null && arguments.length > 0) {
                        String path = PathUtils.concat(tree.getPath(), this.sessionContext.getOakName(arguments[0].toString()));
                        return accessMgr.hasPermissions(path, "add_node");
                    }
                } else if ("setPrimaryType".equals(methodName) || "addMixin".equals(methodName) || "removeMixin".equals(methodName)) {
                    permission = 512L;
                } else if ("orderBefore".equals(methodName)) {
                    if (tree.isRoot()) {
                        return false;
                    }
                    permission = 16384L;
                    tree = tree.getParent();
                } else if ("setProperty".equals(methodName)) {
                    permission = 4L;
                } else if ("remove".equals(methodName)) {
                    permission = 64L;
                }
                return accessMgr.hasPermissions(tree, null, permission);
            }
            if (methodName.equals("setValue")) {
                permission = 8L;
            } else if ("remove".equals(methodName)) {
                permission = 16L;
            }
            Tree tree = ((ItemDelegate)dlg).getParent().getTree();
            return accessMgr.hasPermissions(tree, ((PropertyDelegate)dlg).getPropertyState(), permission);
        }
        return true;
    }

    @Override
    @Nonnull
    public AccessControlManager getAccessControlManager() throws RepositoryException {
        return this.sessionContext.getAccessControlManager();
    }

    @Override
    @Nonnull
    public RetentionManager getRetentionManager() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Retention Management is not supported.");
    }

    @Override
    public void setNamespacePrefix(String prefix, String uri) throws RepositoryException {
        this.sessionContext.getNamespaces().setNamespacePrefix(prefix, uri);
    }

    @Override
    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.sessionContext.getNamespaces().getNamespacePrefixes();
    }

    @Override
    public String getNamespaceURI(String prefix) throws RepositoryException {
        return this.sessionContext.getNamespaces().getNamespaceURI(prefix);
    }

    @Override
    public String getNamespacePrefix(String uri) throws RepositoryException {
        return this.sessionContext.getNamespaces().getNamespacePrefix(uri);
    }

    @Override
    @Nonnull
    public PrincipalManager getPrincipalManager() throws RepositoryException {
        return this.sessionContext.getPrincipalManager();
    }

    @Override
    @Nonnull
    public UserManager getUserManager() throws RepositoryException {
        return this.sessionContext.getUserManager();
    }

    public String toString() {
        return this.sd.getContentSession().toString();
    }

    private abstract class WriteOperation<T>
    extends SessionOperation<T> {
        protected WriteOperation(String name) {
            super(name, true);
        }

        @Override
        public void checkPreconditions() throws RepositoryException {
            SessionImpl.this.sd.checkAlive();
        }
    }

    private abstract class ReadOperation<T>
    extends SessionOperation<T> {
        protected ReadOperation(String name) {
            super(name);
        }

        @Override
        public void checkPreconditions() throws RepositoryException {
            SessionImpl.this.sd.checkAlive();
        }
    }
}

