/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.kernel;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.oak.plugins.memory.AbstractBlob;

public class KernelBlob
extends AbstractBlob {
    private final String binaryID;
    private final MicroKernel kernel;

    public String getBinaryID() {
        return this.binaryID;
    }

    public KernelBlob(String binaryID, MicroKernel kernel) {
        this.binaryID = binaryID;
        this.kernel = kernel;
    }

    @Override
    @Nonnull
    public InputStream getNewStream() {
        return new MicroKernelInputStream(this.kernel, this.binaryID);
    }

    @Override
    public long length() {
        return this.kernel.getLength(this.binaryID);
    }

    @Override
    public String getReference() {
        return this.binaryID;
    }

    @Override
    public String getContentIdentity() {
        return this.binaryID;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof KernelBlob) {
            KernelBlob that = (KernelBlob)other;
            return this.binaryID.equals(that.binaryID);
        }
        return super.equals(other);
    }

    private static class MicroKernelInputStream
    extends InputStream {
        private final MicroKernel mk;
        private final String id;
        private long pos;
        private long length = -1L;
        private byte[] oneByteBuff;

        public MicroKernelInputStream(MicroKernel mk, String id) {
            this.mk = mk;
            this.id = id;
        }

        @Override
        public long skip(long n) {
            if (n < 0L) {
                return 0L;
            }
            if (this.length == -1L) {
                this.length = this.mk.getLength(this.id);
            }
            n = Math.min(n, this.length - this.pos);
            this.pos += n;
            return n;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            int l = this.mk.read(this.id, this.pos, b, off, len);
            if (l < 0) {
                return l;
            }
            this.pos += (long)l;
            return l;
        }

        @Override
        public int read() throws IOException {
            int len;
            if (this.oneByteBuff == null) {
                this.oneByteBuff = new byte[1];
            }
            if ((len = this.read(this.oneByteBuff, 0, 1)) < 0) {
                return len;
            }
            return this.oneByteBuff[0] & 0xFF;
        }
    }
}

