/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.management;

import com.google.common.base.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementOperation
extends FutureTask<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementOperation.class);
    private static final AtomicInteger idGen = new AtomicInteger();
    protected final int id = idGen.incrementAndGet();
    protected final String name;
    private static final Callable<Long> NOP = new Callable<Long>(){

        @Override
        public Long call() throws Exception {
            return 0L;
        }
    };

    public ManagementOperation(String name, Callable<Long> task) {
        super(task);
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static ManagementOperation done(String name, final long value) {
        return new ManagementOperation("not started", NOP){

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public Long get() {
                return value;
            }

            @Override
            public void run() {
                throw new IllegalStateException("This task is done");
            }

            @Override
            public Status getStatus() {
                return Status.none(this.id, this.name + " not started");
            }
        };
    }

    public Status getStatus() {
        if (this.isCancelled()) {
            return Status.failed(this.id, this.name + " cancelled");
        }
        if (this.isDone()) {
            try {
                return Status.succeeded(this.id, this.name + " completed in " + ManagementOperation.formatTime((Long)this.get()));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return Status.failed(this.id, this.name + " status unknown: " + e.getMessage());
            }
            catch (ExecutionException e) {
                LOG.error(this.name + " failed", e.getCause());
                return Status.failed(this.id, this.name + " failed: " + e.getCause().getMessage());
            }
        }
        return Status.running(this.id, this.name + " running");
    }

    private static String formatTime(long nanos) {
        return TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) + " minutes";
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).add("name", this.name).add("id", this.id).toString();
    }

    public static final class Status {
        public static final String ITEM_CODE = "code";
        public static final String ITEM_ID = "id";
        public static final String ITEM_MESSAGE = "message";
        public static final String[] ITEM_NAMES = new String[]{"code", "id", "message"};
        public static final CompositeType ITEM_TYPES = Status.createItemTypes();
        private final RepositoryManagementMBean.StatusCode code;
        private final int id;
        private final String message;

        private static CompositeType createItemTypes() {
            try {
                return new CompositeType("status", "status", ITEM_NAMES, ITEM_NAMES, new OpenType[]{SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.STRING});
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        private Status(RepositoryManagementMBean.StatusCode code, int id, String message) {
            this.code = code;
            this.id = id;
            this.message = message == null ? "" : message;
        }

        public static Status unavailable(String message) {
            return Status.unavailable(idGen.incrementAndGet(), message);
        }

        public static Status none(String message) {
            return Status.none(idGen.incrementAndGet(), message);
        }

        public static Status initiated(String message) {
            return Status.initiated(idGen.incrementAndGet(), message);
        }

        public static Status running(String message) {
            return Status.running(idGen.incrementAndGet(), message);
        }

        public static Status succeeded(String message) {
            return Status.succeeded(idGen.incrementAndGet(), message);
        }

        public static Status failed(String message) {
            return Status.failed(idGen.incrementAndGet(), message);
        }

        static Status unavailable(int id, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.UNAVAILABLE, id, message);
        }

        static Status none(int id, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.NONE, id, message);
        }

        static Status initiated(int id, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.INITIATED, id, message);
        }

        static Status running(int id, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.RUNNING, id, message);
        }

        static Status succeeded(int id, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.SUCCEEDED, id, message);
        }

        static Status failed(int id, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.FAILED, id, message);
        }

        public static Status fromCompositeData(CompositeData status) {
            int code = Status.toInt(status.get(ITEM_CODE));
            int id = Status.toInt(status.get(ITEM_ID));
            String message = Status.toString(status.get(ITEM_MESSAGE));
            return new Status(RepositoryManagementMBean.StatusCode.values()[code], id, message);
        }

        private static int toInt(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            throw new IllegalArgumentException("Not an integer value:" + value);
        }

        private static String toString(Object value) {
            if (value instanceof String) {
                return (String)value;
            }
            throw new IllegalArgumentException("Not a string value:" + value);
        }

        public CompositeData toCompositeData() {
            try {
                Object[] values = new Object[]{this.code.ordinal(), this.id, this.message};
                return new CompositeDataSupport(ITEM_TYPES, ITEM_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public RepositoryManagementMBean.StatusCode getCode() {
            return this.code;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.code.name;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return RepositoryManagementMBean.StatusCode.SUCCEEDED == this.code;
        }

        public boolean isFailure() {
            return RepositoryManagementMBean.StatusCode.FAILED == this.code;
        }

        public String toString() {
            return Objects.toStringHelper(this).addValue((Object)this.code).add(ITEM_ID, this.id).add(ITEM_MESSAGE, this.message).toString();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            Status status = (Status)that;
            return this.id == status.id && this.code == status.code && this.message.equals(status.message);
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = 31 * result + this.id;
            result = 31 * result + this.message.hashCode();
            return result;
        }
    }
}

