/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;

public class VersionGCSupport {
    private final DocumentStore store;

    public VersionGCSupport(DocumentStore store) {
        this.store = store;
    }

    public Iterable<NodeDocument> getPossiblyDeletedDocs(final long lastModifiedTime) {
        return Iterables.filter(this.getAllDocuments(), new Predicate<NodeDocument>(){

            @Override
            public boolean apply(NodeDocument input) {
                return input.wasDeletedOnce() && !input.hasBeenModifiedSince(lastModifiedTime);
            }
        });
    }

    public int deleteSplitDocuments(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp) {
        ArrayList<String> docsToDelete = Lists.newArrayList();
        for (NodeDocument doc : this.getAllDocuments()) {
            NodeDocument.SplitDocType splitType = doc.getSplitDocType();
            if (!gcTypes.contains((Object)splitType) || !doc.hasAllRevisionLessThan(oldestRevTimeStamp)) continue;
            docsToDelete.add(doc.getId());
        }
        this.store.remove(Collection.NODES, docsToDelete);
        return docsToDelete.size();
    }

    private List<NodeDocument> getAllDocuments() {
        return this.store.query(Collection.NODES, "0000000", ";", Integer.MAX_VALUE);
    }
}

