/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;

public class SynchronizingDocumentStoreWrapper
implements DocumentStore {
    final DocumentStore store;

    public SynchronizingDocumentStoreWrapper(DocumentStore store) {
        this.store = store;
    }

    @Override
    public synchronized <T extends Document> T find(Collection<T> collection, String key) {
        return this.store.find(collection, key);
    }

    @Override
    public synchronized <T extends Document> T find(Collection<T> collection, String key, int maxCacheAge) {
        return this.store.find(collection, key, maxCacheAge);
    }

    @Override
    @Nonnull
    public synchronized <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.store.query(collection, fromKey, toKey, limit);
    }

    @Override
    @Nonnull
    public synchronized <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        return this.store.query(collection, fromKey, toKey, indexedProperty, startValue, limit);
    }

    @Override
    public synchronized <T extends Document> void remove(Collection<T> collection, String key) {
        this.store.remove(collection, key);
    }

    @Override
    public synchronized <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        for (String key : keys) {
            this.remove(collection, key);
        }
    }

    @Override
    public synchronized <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        return this.store.create(collection, updateOps);
    }

    @Override
    public synchronized <T extends Document> void update(Collection<T> collection, List<String> keys, UpdateOp updateOp) {
        this.store.update(collection, keys, updateOp);
    }

    @Override
    @Nonnull
    public synchronized <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) throws MicroKernelException {
        return this.store.createOrUpdate(collection, update);
    }

    @Override
    public synchronized <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) throws MicroKernelException {
        return this.store.findAndUpdate(collection, update);
    }

    @Override
    public synchronized void invalidateCache() {
        this.store.invalidateCache();
    }

    @Override
    public synchronized <T extends Document> void invalidateCache(Collection<T> collection, String key) {
        this.store.invalidateCache(collection, key);
    }

    @Override
    public synchronized void dispose() {
        this.store.dispose();
    }

    @Override
    public synchronized <T extends Document> T getIfCached(Collection<T> collection, String key) {
        return this.store.getIfCached(collection, key);
    }

    @Override
    public synchronized void setReadWriteMode(String readWriteMode) {
        this.store.setReadWriteMode(readWriteMode);
    }
}

