/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.InImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.query.index.FilterImpl;

public class OrImpl
extends ConstraintImpl {
    private ConstraintImpl constraint1;
    private ConstraintImpl constraint2;

    public OrImpl(ConstraintImpl constraint1, ConstraintImpl constraint2) {
        this.constraint1 = constraint1;
        this.constraint2 = constraint2;
    }

    public ConstraintImpl getConstraint1() {
        return this.constraint1;
    }

    public ConstraintImpl getConstraint2() {
        return this.constraint2;
    }

    @Override
    public ConstraintImpl simplify() {
        this.constraint1 = this.constraint1.simplify();
        this.constraint2 = this.constraint2.simplify();
        if (this.constraint1.equals(this.constraint2)) {
            return this.constraint1;
        }
        return this;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        Set<PropertyExistenceImpl> s1 = this.constraint1.getPropertyExistenceConditions();
        if (s1.isEmpty()) {
            return s1;
        }
        Set<PropertyExistenceImpl> s2 = this.constraint2.getPropertyExistenceConditions();
        if (s2.isEmpty()) {
            return s2;
        }
        return Sets.intersection(s1, s2);
    }

    @Override
    public FullTextExpression getFullTextConstraint(SelectorImpl s) {
        FullTextExpression f1 = this.constraint1.getFullTextConstraint(s);
        FullTextExpression f2 = this.constraint2.getFullTextConstraint(s);
        if (f1 == null || f2 == null) {
            return null;
        }
        ArrayList<FullTextExpression> list = new ArrayList<FullTextExpression>();
        list.add(f1);
        list.add(f2);
        return new FullTextOr(list);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        Set<SelectorImpl> s1 = this.constraint1.getSelectors();
        Set<SelectorImpl> s2 = this.constraint2.getSelectors();
        if (s1.isEmpty()) {
            return s2;
        }
        if (s2.isEmpty()) {
            return s1;
        }
        return Sets.union(s1, s2);
    }

    @Override
    public Map<DynamicOperandImpl, Set<StaticOperandImpl>> getInMap() {
        Map<DynamicOperandImpl, Set<StaticOperandImpl>> m1 = this.constraint1.getInMap();
        Map<DynamicOperandImpl, Set<StaticOperandImpl>> m2 = this.constraint2.getInMap();
        if (m1.isEmpty()) {
            return m1;
        }
        if (m2.isEmpty()) {
            return m2;
        }
        HashMap<DynamicOperandImpl, Set<StaticOperandImpl>> result = Maps.newHashMap();
        for (Map.Entry<DynamicOperandImpl, Set<StaticOperandImpl>> e2 : m2.entrySet()) {
            Set<StaticOperandImpl> l2 = e2.getValue();
            Set<StaticOperandImpl> l1 = m1.get(e2.getKey());
            if (l1 == null || l1.isEmpty() || l2.isEmpty()) continue;
            Sets.SetView<StaticOperandImpl> list = Sets.union(l1, l2);
            result.put(e2.getKey(), list);
        }
        return result;
    }

    @Override
    public boolean evaluate() {
        return this.constraint1.evaluate() || this.constraint2.evaluate();
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return this.protect(this.constraint1) + " or " + this.protect(this.constraint2);
    }

    @Override
    public void restrict(FilterImpl f) {
        Set<PropertyExistenceImpl> set = this.getPropertyExistenceConditions();
        if (!set.isEmpty()) {
            for (PropertyExistenceImpl p : set) {
                p.restrict(f);
            }
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        this.restrictPushDownNotExists(s);
        this.restrictPushDownInList(s);
    }

    private void restrictPushDownInList(SelectorImpl s) {
        if (this.isOnlySelector(s)) {
            Map<DynamicOperandImpl, Set<StaticOperandImpl>> m = this.getInMap();
            for (Map.Entry<DynamicOperandImpl, Set<StaticOperandImpl>> e : m.entrySet()) {
                Set<StaticOperandImpl> set = e.getValue();
                if (set.size() <= 1) continue;
                InImpl in = new InImpl(e.getKey(), Lists.newArrayList(set));
                in.setQuery(this.query);
                in.restrictPushDown(s);
            }
        }
    }

    private void restrictPushDownNotExists(SelectorImpl s) {
        Set<PropertyExistenceImpl> set = this.getPropertyExistenceConditions();
        if (set.isEmpty()) {
            return;
        }
        for (PropertyExistenceImpl p : set) {
            p.restrictPushDown(s);
        }
    }

    private boolean isOnlySelector(SelectorImpl s) {
        Set<SelectorImpl> set = this.getSelectors();
        if (set.size() == 0) {
            return true;
        }
        if (set.size() > 1) {
            return false;
        }
        SelectorImpl s2 = set.iterator().next();
        return s2.equals(s);
    }
}

