/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.token;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.token.CompositeTokenProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;

public final class CompositeTokenConfiguration
extends CompositeConfiguration<TokenConfiguration>
implements TokenConfiguration {
    public CompositeTokenConfiguration(@Nonnull SecurityProvider securityProvider) {
        super("org.apache.jackrabbit.oak.authentication.token", securityProvider);
    }

    @Override
    @Nonnull
    public TokenProvider getTokenProvider(final Root root) {
        List<TokenProvider> providers = Lists.transform(this.getConfigurations(), new Function<TokenConfiguration, TokenProvider>(){

            @Override
            public TokenProvider apply(TokenConfiguration tokenConfiguration) {
                return tokenConfiguration.getTokenProvider(root);
            }
        });
        return CompositeTokenProvider.newInstance(providers);
    }
}

