/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.AccessControlAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={AuthorizableActionProvider.class})
public class DefaultAuthorizableActionProvider
implements AuthorizableActionProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthorizableActionProvider.class);
    private static final String ENABLED_ACTIONS = "enabledActions";
    @Property(name="enabledActions", options={@PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.AccessControlAction", value="AccessControlAction"), @PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.PasswordValidationAction", value="PasswordValidationAction"), @PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.PasswordChangeAction", value="PasswordChangeAction"), @PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.ClearMembershipAction", value="ClearMembershipAction")})
    private String[] enabledActions = new String[]{AccessControlAction.class.getName()};
    private ConfigurationParameters config = ConfigurationParameters.EMPTY;

    public DefaultAuthorizableActionProvider() {
    }

    public DefaultAuthorizableActionProvider(ConfigurationParameters config) {
        this.config = config;
    }

    @Override
    public List<? extends AuthorizableAction> getAuthorizableActions(SecurityProvider securityProvider) {
        ArrayList<AuthorizableAction> actions = Lists.newArrayList();
        for (String className : this.enabledActions) {
            try {
                Object o = Class.forName(className).newInstance();
                if (!(o instanceof AuthorizableAction)) continue;
                actions.add((AuthorizableAction)o);
            }
            catch (Exception e) {
                log.debug("Unable to create authorizable action", (Throwable)e);
            }
        }
        for (AuthorizableAction action : actions) {
            action.init(securityProvider, this.config);
        }
        return actions;
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.config = ConfigurationParameters.of(properties);
    }
}

