/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Calendar;
import java.util.Map;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRAccountingEntryPaste
extends JCRAccountingEntry
implements AccountingEntryPaste {
    private final String fromPath;

    public JCRAccountingEntryPaste(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.fromPath = (String)new XStream().fromXML(node.getAccountingProperties().get((Object)AccountingProperty.FROM_PATH));
    }

    public JCRAccountingEntryPaste(String id, String user, Calendar date, String fromPath) {
        super(id, user, date);
        this.fromPath = fromPath;
        Map<AccountingProperty, String> properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.FROM_PATH, new XStream().toXML(fromPath));
        this.entryDelegate.setEntryType(AccountingEntryType.PASTE);
    }

    @Override
    public String getFromPath() {
        return this.fromPath;
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.PASTE;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s, fromPath:%s]]", new Object[]{parentValue, AccountingEntryType.PASTE, (String)new XStream().fromXML(this.entryDelegate.getAccountingProperties().get((Object)AccountingProperty.FROM_PATH))});
    }
}

