/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.event.system;

import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.core.event.EventType;
import com.couchbase.client.core.utils.Events;
import com.couchbase.client.core.utils.NetworkAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConfigUpdatedEvent
implements CouchbaseEvent {
    private final Set<String> bucketNames;
    private final Set<NetworkAddress> clusterNodes;

    public ConfigUpdatedEvent(ClusterConfig clusterConfig) {
        this.bucketNames = clusterConfig.bucketConfigs().keySet();
        HashSet<NetworkAddress> nodes = new HashSet<NetworkAddress>();
        for (Map.Entry<String, BucketConfig> cfg : clusterConfig.bucketConfigs().entrySet()) {
            for (NodeInfo node : cfg.getValue().nodes()) {
                nodes.add(node.hostname());
            }
        }
        this.clusterNodes = nodes;
    }

    public Set<String> openBuckets() {
        return this.bucketNames;
    }

    @Deprecated
    public Set<InetAddress> clusterNodes() {
        HashSet<InetAddress> nodes = new HashSet<InetAddress>();
        for (NetworkAddress na : this.clusterNodes) {
            try {
                nodes.add(InetAddress.getByName(na.address()));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
        return nodes;
    }

    public Set<NetworkAddress> clusterNodesAsNetworkAddress() {
        return this.clusterNodes;
    }

    @Override
    public EventType type() {
        return EventType.SYSTEM;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = Events.identityMap(this);
        result.put("openBuckets", this.openBuckets());
        HashSet<String> clusterNodes = new HashSet<String>();
        for (NetworkAddress node : this.clusterNodes) {
            clusterNodes.add(node.toString());
        }
        result.put("clusterNodes", clusterNodes);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConfigUpdatedEvent{");
        sb.append("bucketNames=").append(this.bucketNames);
        sb.append(", clusterNodes=").append(this.clusterNodes);
        sb.append('}');
        return sb.toString();
    }
}

