/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ReplicaNotAvailableException;
import com.couchbase.client.core.ReplicaNotConfiguredException;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.GetAllMutationTokensRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.NoopRequest;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ObserveSeqnoRequest;
import com.couchbase.client.core.message.kv.ReplicaGetRequest;
import com.couchbase.client.core.message.kv.StatRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.List;
import java.util.zip.CRC32;

public class KeyValueLocator
implements Locator {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueLocator.class);
    private static final int MIN_KEY_BYTES = 1;
    private static final int MAX_KEY_BYTES = 250;

    @Override
    public void locateAndDispatch(CouchbaseRequest request, List<Node> nodes, ClusterConfig cluster, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        if (request instanceof GetBucketConfigRequest) {
            KeyValueLocator.locateByHostname(request, ((GetBucketConfigRequest)request).hostname(), nodes, env, responseBuffer);
            return;
        }
        if (request instanceof StatRequest) {
            KeyValueLocator.locateByHostname(request, ((StatRequest)request).hostname(), nodes, env, responseBuffer);
            return;
        }
        if (request instanceof GetAllMutationTokensRequest) {
            KeyValueLocator.locateByHostname(request, ((GetAllMutationTokensRequest)request).hostname(), nodes, env, responseBuffer);
            return;
        }
        if (request instanceof NoopRequest) {
            KeyValueLocator.locateByHostname(request, ((NoopRequest)request).hostname(), nodes, env, responseBuffer);
            return;
        }
        BucketConfig bucket = cluster.bucketConfig(request.bucket());
        if (bucket instanceof CouchbaseBucketConfig) {
            KeyValueLocator.locateForCouchbaseBucket((BinaryRequest)request, nodes, (CouchbaseBucketConfig)bucket, env, responseBuffer);
        } else if (bucket instanceof MemcachedBucketConfig) {
            KeyValueLocator.locateForMemcacheBucket((BinaryRequest)request, nodes, (MemcachedBucketConfig)bucket, env, responseBuffer);
        } else {
            throw new IllegalStateException("Unsupported Bucket Type: " + bucket + " for request " + request);
        }
    }

    private static void locateByHostname(CouchbaseRequest request, NetworkAddress hostname, List<Node> nodes, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        for (Node node : nodes) {
            if (!node.isState(LifecycleState.CONNECTED) && !node.isState(LifecycleState.DEGRADED) || !hostname.equals(node.hostname())) continue;
            node.send(request);
            return;
        }
        RetryHelper.retryOrCancel(env, request, responseBuffer);
    }

    private static void locateForCouchbaseBucket(BinaryRequest request, List<Node> nodes, CouchbaseBucketConfig config, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        if (!KeyValueLocator.keyIsValid(request)) {
            return;
        }
        int partitionId = KeyValueLocator.partitionForKey(request.keyBytes(), config.numberOfPartitions());
        request.partition((short)partitionId);
        int nodeId = KeyValueLocator.calculateNodeId(partitionId, request, config);
        if (nodeId < 0) {
            KeyValueLocator.errorObservables(nodeId, request, config.name(), env, responseBuffer);
            return;
        }
        NodeInfo nodeInfo = config.nodeAtIndex(nodeId);
        for (Node node : nodes) {
            if (!node.hostname().equals(nodeInfo.hostname())) continue;
            node.send(request);
            return;
        }
        if (KeyValueLocator.handleNotEqualNodeSizes(config.nodes().size(), nodes.size())) {
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        throw new IllegalStateException("Node not found for request" + request);
    }

    private static int calculateNodeId(int partitionId, BinaryRequest request, CouchbaseBucketConfig config) {
        boolean useFastForward;
        boolean bl = useFastForward = request.retryCount() > 0 && config.hasFastForwardMap();
        if (request instanceof ReplicaGetRequest) {
            return config.nodeIndexForReplica(partitionId, ((ReplicaGetRequest)request).replica() - 1, useFastForward);
        }
        if (request instanceof ObserveRequest && ((ObserveRequest)request).replica() > 0) {
            return config.nodeIndexForReplica(partitionId, ((ObserveRequest)request).replica() - 1, useFastForward);
        }
        if (request instanceof ObserveSeqnoRequest && ((ObserveSeqnoRequest)request).replica() > 0) {
            return config.nodeIndexForReplica(partitionId, ((ObserveSeqnoRequest)request).replica() - 1, useFastForward);
        }
        return config.nodeIndexForMaster(partitionId, useFastForward);
    }

    private static void errorObservables(int nodeId, BinaryRequest request, String name, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        if (nodeId == -2) {
            if (request instanceof ReplicaGetRequest) {
                request.observable().onError(new ReplicaNotConfiguredException("Replica number " + ((ReplicaGetRequest)request).replica() + " not configured for bucket " + name));
                return;
            }
            if (request instanceof ObserveRequest) {
                request.observable().onError(new ReplicaNotConfiguredException("Replica number " + ((ObserveRequest)request).replica() + " not configured for bucket " + name));
                return;
            }
            if (request instanceof ObserveSeqnoRequest) {
                request.observable().onError(new ReplicaNotConfiguredException("Replica number " + ((ObserveSeqnoRequest)request).replica() + " not configured for bucket " + name));
                return;
            }
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        if (nodeId == -1) {
            if (request instanceof ObserveRequest) {
                request.observable().onError(new ReplicaNotAvailableException("Replica number " + ((ObserveRequest)request).replica() + " not available for bucket " + name));
                return;
            }
            if (request instanceof ReplicaGetRequest) {
                request.observable().onError(new ReplicaNotAvailableException("Replica number " + ((ReplicaGetRequest)request).replica() + " not available for bucket " + name));
                return;
            }
            if (request instanceof ObserveSeqnoRequest) {
                request.observable().onError(new ReplicaNotAvailableException("Replica number " + ((ObserveSeqnoRequest)request).replica() + " not available for bucket " + name));
                return;
            }
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        throw new IllegalStateException("Unknown NodeId: " + nodeId + ", request: " + request);
    }

    private static int partitionForKey(byte[] key, int numPartitions) {
        CRC32 crc32 = new CRC32();
        crc32.update(key);
        long rv = crc32.getValue() >> 16 & 0x7FFFL;
        return (int)rv & numPartitions - 1;
    }

    private static void locateForMemcacheBucket(BinaryRequest request, List<Node> nodes, MemcachedBucketConfig config, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        if (!KeyValueLocator.keyIsValid(request)) {
            return;
        }
        NetworkAddress hostname = config.nodeForId(request.keyBytes());
        request.partition((short)0);
        for (Node node : nodes) {
            if (!node.hostname().equals(hostname)) continue;
            node.send(request);
            return;
        }
        if (KeyValueLocator.handleNotEqualNodeSizes(config.nodes().size(), nodes.size())) {
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        throw new IllegalStateException("Node not found for request" + request);
    }

    private static boolean handleNotEqualNodeSizes(int configNodeSize, int actualNodeSize) {
        if (configNodeSize != actualNodeSize) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Node list and configuration's partition hosts sizes : {} <> {}, rescheduling", (Object)actualNodeSize, (Object)configNodeSize);
            }
            return true;
        }
        return false;
    }

    private static boolean keyIsValid(BinaryRequest request) {
        if (request.keyBytes() == null || request.keyBytes().length < 1) {
            request.observable().onError(new IllegalArgumentException("The Document ID must not be null or empty."));
            return false;
        }
        if (request.keyBytes().length > 250) {
            request.observable().onError(new IllegalArgumentException("The Document ID must not be longer than 250 bytes."));
            return false;
        }
        return true;
    }
}

