/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.connections.Connection;
import org.gcube.documentstore.persistence.connections.Connections;
import org.gcube.documentstore.persistence.connections.Nodes;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceCouchBase
extends PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceCouchBase.class);
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String BUCKET_NAME_PROPERTY_KEY = "bucketName";
    public static final long TIMEOUT_BUCKET = TimeUnit.SECONDS.toMillis(180L);
    public static final long ALIVE_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    protected Map<String, String> bucketNames;
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout(TIMEOUT_BUCKET).keepAliveInterval(ALIVE_INTERVAL).build();
    private Nodes nodes;
    private String password;

    protected void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        String url = configuration.getProperty(URL_PROPERTY_KEY);
        this.password = configuration.getProperty(PASSWORD_PROPERTY_KEY);
        this.nodes = new Nodes(url);
        logger.debug("PersistenceCouchBase prepareConnection url:{} and now is connectionsMap:{}", (Object)url, Connections.connectionsMap);
        this.bucketNames = new HashMap<String, String>();
        Map recordClasses = RecordUtility.getRecordClassesFound();
        for (Class recordClass : recordClasses.values()) {
            Record recordInstance = (Record)recordClass.newInstance();
            if (!(recordInstance instanceof Record) || recordInstance instanceof AggregatedRecord) continue;
            try {
                Class recordClazz = recordClass;
                logger.debug("Trying to get the Bucket for {}", (Object)recordClazz);
                String recordType = recordInstance.getRecordType();
                String bucketName = configuration.getProperty(recordType);
                logger.debug("Bucket for {} is {}.", (Object)recordClazz, (Object)bucketName);
                this.bucketNames.put(recordType, bucketName);
            }
            catch (Exception e) {
                logger.info("Unable to open Bucket for type {}", (Object)recordClass, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openConnection() throws Exception {
        Map<Nodes, Connection> map = Connections.connectionsMap;
        synchronized (map) {
            if (!Connections.connectionsMap.containsKey(this.nodes)) {
                Cluster cluster = null;
                try {
                    cluster = CouchbaseCluster.create(ENV, this.nodes.getNodes());
                    Connections.connectionsMap.put(this.nodes, new Connection(cluster));
                    logger.trace("PersistenceCouchBase openConnection insert nodes:{}", Connections.connectionsMap);
                }
                catch (Exception e) {
                    if (cluster != null) {
                        cluster.disconnect();
                    }
                    logger.error("Bucket connection error", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bucket getBucketConnection(String recordType) {
        Bucket bucket = null;
        Map<Nodes, Connection> map = Connections.connectionsMap;
        synchronized (map) {
            bucket = Connections.connectionsMap.get(this.nodes).getBucketsMap().get(this.bucketNames.get(recordType));
            try {
                if (bucket == null) {
                    bucket = Connections.connectionsMap.get(this.nodes).getCluster().openBucket(this.bucketNames.get(recordType), this.password);
                    logger.trace("PersistenceCouchBase getBucketConnection bucket close, open:{}", (Object)bucket.toString());
                    Connections.connectionsMap.get(this.nodes).getBucketsMap().put(this.bucketNames.get(recordType), bucket);
                    logger.trace("PersistenceCouchBase getBucketConnection connectionMap:{}", Connections.connectionsMap.get(this.nodes).getBucketsMap());
                }
            }
            catch (Exception e) {
                logger.error("getBucketConnection connection error", (Throwable)e);
                throw e;
            }
        }
        return bucket;
    }

    protected JsonDocument createItem(JsonObject jsonObject, String id, String recordType) throws Exception {
        JsonDocument doc = JsonDocument.create(id, jsonObject);
        return this.getBucketConnection(recordType).upsert(doc);
    }

    public static JsonNode usageRecordToJsonNode(Record record) throws Exception {
        JsonNode node = DSMapper.getObjectMapper().valueToTree((Object)DSMapper.marshal((Record)record));
        return node;
    }

    public static Record jsonNodeToUsageRecord(JsonNode jsonNode) throws Exception {
        return (Record)DSMapper.getObjectMapper().convertValue((Object)jsonNode, Record.class);
    }

    protected void reallyAccount(Record record) throws Exception {
        JsonObject jsonObject = JsonObject.fromJson(DSMapper.marshal((Record)record));
        String recordType = record.getRecordType();
        this.createItem(jsonObject, record.getId(), recordType);
    }

    public boolean isConnectionActive() throws Exception {
        return !Connections.connectionsMap.get(this.nodes).getBucketsMap().values().iterator().next().isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean() throws Exception {
        Map<Nodes, Connection> map = Connections.connectionsMap;
        synchronized (map) {
            try {
                if (!Connections.connectionsMap.isEmpty()) {
                    for (Map.Entry<String, Bucket> entry : Connections.connectionsMap.get(this.nodes).getBucketsMap().entrySet()) {
                        Boolean closed = entry.getValue().close();
                        if (closed.booleanValue()) continue;
                        logger.warn("bucket not close :{}", (Object)entry.getKey());
                    }
                    Boolean clusterClosed = Connections.connectionsMap.get(this.nodes).getCluster().disconnect();
                    if (!clusterClosed.booleanValue()) {
                        logger.warn("cluster not disconnect");
                    }
                    Connections.connectionsMap.remove(this.nodes);
                    logger.trace("PersistenceCouchBase disconnect");
                } else {
                    logger.warn("cluster not open");
                }
            }
            catch (Exception e) {
                logger.error("closeAndClean error with close and clean", (Throwable)e);
                throw e;
            }
        }
    }

    protected void closeConnection() throws Exception {
        logger.trace("PersistenceCouchBase closeConnection");
    }
}

