/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.service.AbstractDynamicService;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.state.LifecycleState;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscriber;
import rx.functions.Action1;

public abstract class AbstractLazyService
extends AbstractDynamicService {
    private final AtomicReference<Endpoint> storedEndpoint = new AtomicReference();

    protected AbstractLazyService(String hostname, String bucket, String username, String password, int port, CoreContext ctx, Service.EndpointFactory endpointFactory) {
        super(hostname, bucket, username, password, port, ctx, 0, endpointFactory);
    }

    @Override
    protected void dispatch(final CouchbaseRequest request) {
        if (this.storedEndpoint.get() == null) {
            final Endpoint newEndpoint = this.createEndpoint();
            if (this.storedEndpoint.compareAndSet(null, newEndpoint)) {
                this.endpointStates().register(newEndpoint, newEndpoint);
                newEndpoint.connect().subscribe(new Subscriber<LifecycleState>(){

                    @Override
                    public void onCompleted() {
                    }

                    @Override
                    public void onError(Throwable e) {
                        request.observable().onError(e);
                    }

                    @Override
                    public void onNext(LifecycleState lifecycleState) {
                        if (lifecycleState == LifecycleState.DISCONNECTED) {
                            request.observable().onError(new CouchbaseException("Could not connect storedEndpoint."));
                        }
                    }
                });
                AbstractLazyService.whenState(newEndpoint, LifecycleState.DISCONNECTED, new Action1<LifecycleState>(){

                    @Override
                    public void call(LifecycleState lifecycleState) {
                        AbstractLazyService.this.endpointStates().deregister(newEndpoint);
                        AbstractLazyService.this.storedEndpoint.set(null);
                    }
                });
            } else {
                newEndpoint.disconnect();
            }
        }
        AbstractLazyService.sendAndFlushWhenConnected(this.storedEndpoint.get(), request);
    }

    private static void sendAndFlushWhenConnected(final Endpoint endpoint, final CouchbaseRequest request) {
        AbstractLazyService.whenState(endpoint, LifecycleState.CONNECTED, new Action1<LifecycleState>(){

            @Override
            public void call(LifecycleState lifecycleState) {
                endpoint.send(request);
                endpoint.send(SignalFlush.INSTANCE);
            }
        });
    }

    Endpoint endpoint() {
        return this.storedEndpoint.get();
    }
}

