/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.internal;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.NetworkAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class PingServiceHealth {
    private final ServiceType serviceType;
    private final PingState pingState;
    private final String id;
    private final long latency;
    private final InetSocketAddress local;
    private final InetSocketAddress remote;
    private final String scope;

    public PingServiceHealth(ServiceType serviceType, PingState pingState, String id, long latency, SocketAddress localAddr, SocketAddress remoteAddr, String scope) {
        this.serviceType = serviceType;
        this.pingState = pingState;
        this.id = id;
        this.latency = latency;
        if (localAddr == null) {
            this.local = null;
        } else {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Right now only InetSocketAddress is supported");
            }
            this.local = (InetSocketAddress)localAddr;
        }
        if (remoteAddr == null) {
            this.remote = null;
        } else {
            if (!(remoteAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Right now only InetSocketAddress is supported");
            }
            this.remote = (InetSocketAddress)remoteAddr;
        }
        this.scope = scope;
    }

    public ServiceType type() {
        return this.serviceType;
    }

    public String scope() {
        return this.scope;
    }

    public PingState state() {
        return this.pingState;
    }

    public String id() {
        return this.id;
    }

    public long latency() {
        return this.latency;
    }

    public InetSocketAddress local() {
        return this.local;
    }

    public InetSocketAddress remote() {
        return this.remote;
    }

    public Map<String, Object> toMap() {
        NetworkAddress ra = this.remote() == null ? null : NetworkAddress.create(this.remote().getAddress().getHostAddress());
        NetworkAddress la = this.local() == null ? null : NetworkAddress.create(this.local().getAddress().getHostAddress());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("remote", ra == null ? "" : ra.nameOrAddress() + ":" + this.remote().getPort());
        map.put("local", la == null ? "" : la.nameOrAddress() + ":" + this.local().getPort());
        map.put("state", this.pingState.asJson());
        map.put("latency_us", this.latency);
        if (this.scope != null && !this.scope.isEmpty()) {
            map.put("scope", this.scope);
        }
        map.put("id", this.id());
        return map;
    }

    public String toString() {
        return "PingServiceHealth{serviceType=" + (Object)((Object)this.serviceType) + ", pingState=" + (Object)((Object)this.pingState) + ", id='" + this.id + '\'' + ", latency=" + this.latency + ", local='" + this.local + '\'' + ", remote='" + this.remote + '\'' + ", scope='" + this.scope + '\'' + '}';
    }

    public static enum PingState {
        OK("ok"),
        TIMEOUT("timeout"),
        ERROR("error");

        private final String val;

        private PingState(String val) {
            this.val = val;
        }

        public String asJson() {
            return this.val;
        }
    }
}

