/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.InputStream;
import java.net.UnknownHostException;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.SoftCopy;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoOperationManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftCopyOperator
extends SoftCopy {
    Logger logger = LoggerFactory.getLogger(SoftCopyOperator.class);
    private MemoryType memoryType;
    private MongoIOManager mongoPrimaryInstance;
    private MyFile resource;

    public SoftCopyOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String execute(MongoIOManager mongoPrimaryInstance, MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = resource.getOperation().getRemoteResource();
        OperationDefinition.LOCAL_RESOURCE localResourceIdentifier = resource.getOperation().getLocalResource();
        String source = null;
        source = localResourceIdentifier.equals((Object)OperationDefinition.LOCAL_RESOURCE.ID) ? resource.getId() : sourcePath;
        String destination = null;
        destination = remoteResourceIdentifier.equals((Object)OperationDefinition.REMOTE_RESOURCE.ID) ? resource.getId() : destinationPath;
        if (resource != null) {
            String dir = resource.getRemoteDir();
            String name = resource.getName();
            this.setMemoryType(resource.getGcubeMemoryType());
        }
        this.setMongoPrimaryInstance(mongoPrimaryInstance);
        ObjectId mapId = null;
        GridFSDBFile destObject = null;
        this.logger.debug("softCopy operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source == null || source.isEmpty()) throw new RemoteBackendException("Invalid arguments: source " + source + " destination " + destination);
        GridFSDBFile sourceObject = mongoPrimaryInstance.retrieveRemoteDescriptor(source, remoteResourceIdentifier, true);
        if (sourceObject != null) {
            sourceObject = mongoPrimaryInstance.retrieveLinkPayload(sourceObject);
            ObjectId sourceId = (ObjectId)sourceObject.getId();
            InputStream is = sourceObject.getInputStream();
            resource.setInputStream(is);
            GridFSDBFile dest = null;
            if (destination == null || destination.isEmpty()) {
                if (sourceId == null) {
                    throw new RemoteBackendException("source object not found: " + source);
                }
                destination = this.fillGenericDestinationFields(resource, sourceId);
                this.logger.warn("SoftCopy without destination parameter. The operation will be executed with the following destination path " + destination);
            } else {
                dest = mongoPrimaryInstance.retrieveRemoteDescriptor(destination, remoteResourceIdentifier, false);
            }
            ObjectId removedId = null;
            if (dest != null) {
                if (!resource.isReplace()) return dest.getId().toString();
                removedId = mongoPrimaryInstance.removeFile(resource, null, resource.isReplace(), null, dest);
            }
            DBCollection metaCollectionInstance = this.getMetaCollection();
            String md5 = sourceObject.getMD5();
            ObjectId md5Id = this.getDuplicatesMap(md5);
            if (this.isMap(sourceObject)) {
                this.logger.debug("the sourceObject with the following id: " + mapId + " is already a map");
                mapId = sourceId;
                DBObject newObject = this.createNewLinkObject(resource, sourceObject, destination, metaCollectionInstance, md5, mapId, removedId);
                destObject = mongoPrimaryInstance.retrieveRemoteDescriptor(destination, remoteResourceIdentifier, true);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, destObject);
            } else if (md5Id != null) {
                mapId = md5Id;
                this.logger.debug("retrieved md5 on backend with the following id: " + mapId);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, sourceObject);
                DBObject newObject = this.createNewLinkObject(resource, sourceObject, destination, metaCollectionInstance, md5, mapId, removedId);
                destObject = mongoPrimaryInstance.retrieveRemoteDescriptor(destination, remoteResourceIdentifier, true);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, destObject);
            } else {
                mapId = this.createNewDuplicatesMap(metaCollectionInstance, resource, sourceObject, destination, sourceId);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, sourceObject);
                DBObject newObject = this.createNewLinkObject(resource, sourceObject, destination, metaCollectionInstance, md5, mapId, removedId);
                destObject = mongoPrimaryInstance.retrieveRemoteDescriptor(destination, remoteResourceIdentifier, true);
                mapId = this.addToDuplicateMap(metaCollectionInstance, mapId, destObject);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("mapId created/updated: " + mapId);
            }
        } else {
            mongoPrimaryInstance.close();
            throw new RemoteBackendException(" the source path is wrong. There isn't a file at " + source);
        }
        mongoPrimaryInstance.close();
        return destObject.getId().toString();
    }

    private String fillGenericDestinationFields(MyFile resource, ObjectId souceId) {
        String destination = resource.getRootPath() + souceId;
        resource.setName(souceId.toString());
        resource.setRemoteDir(resource.getRootPath());
        return destination;
    }

    private ObjectId createNewDuplicatesMap(DBCollection metaCollectionInstance, Object resource, GridFSDBFile sourceObject, String bucket, ObjectId sourceId) throws UnknownHostException {
        ObjectId id = null;
        String dir = ((MyFile)resource).getRemoteDir();
        if (dir != null && !dir.isEmpty() && bucket != null && !bucket.isEmpty()) {
            this.getMongoPrimaryInstance().buildDirTree(this.getMongoPrimaryInstance().getMetaDataCollection(null), dir);
        }
        id = this.createNewObjectMap(metaCollectionInstance, (MyFile)resource, sourceObject, sourceId);
        return id;
    }

    private ObjectId createNewObjectMap(DBCollection metaCollectionInstance, MyFile resource, GridFSDBFile source, ObjectId sourceId) throws UnknownHostException {
        String md5 = source.getMD5();
        DBObject document = new BasicDBObject("type", "map");
        document.put("count", 0);
        ObjectId id = new ObjectId();
        document.put("_id", id);
        this.logger.debug("generated id for new map" + id);
        document = this.fillCommonfields(document, resource, source, metaCollectionInstance, md5);
        this.getMongoPrimaryInstance().updateChunksCollection(sourceId, id);
        return id;
    }

    private DBObject createNewLinkObject(MyFile resource, GridFSDBFile sourceObject, String destination, DBCollection metaCollectionInstance, String md5, ObjectId mapId, ObjectId newId) {
        BasicDBObject document = new BasicDBObject("type", "file");
        document.put("filename", destination);
        document.put("name", resource.getName());
        document.put("dir", resource.getRemoteDir());
        document.put("owner", resource.getOwner());
        document.put("link", mapId.toString());
        ObjectId id = null;
        if (newId == null) {
            id = new ObjectId();
            this.logger.debug("generated id for new object link" + id);
        } else {
            id = newId;
            this.logger.debug("restored id for new object link" + id);
        }
        document.put("_id", id);
        return this.fillCommonfields(document, resource, sourceObject, metaCollectionInstance, md5);
    }

    private DBObject fillCommonfields(DBObject document, MyFile resource, GridFSDBFile sourceObject, DBCollection metaCollectionInstance, String md5) {
        document.put("mimetype", resource.getMimeType());
        document.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
        document.put("md5", md5);
        document.put("length", sourceObject.getLength());
        document.put("chunkSize", sourceObject.getChunkSize());
        metaCollectionInstance.insert(document);
        metaCollectionInstance.save(document);
        return document;
    }

    private DBCollection getMetaCollection() throws UnknownHostException {
        DBCollection metaCollectionInstance = null;
        metaCollectionInstance = this.getMemoryType() != MemoryType.VOLATILE ? this.mongoPrimaryInstance.getMetaDataCollection(this.mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), true)) : this.mongoPrimaryInstance.getMetaDataCollection(this.mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), false));
        return metaCollectionInstance;
    }

    private ObjectId addToDuplicateMap(DBCollection metaCollectionInstance, ObjectId mapId, GridFSDBFile f) throws UnknownHostException {
        f.put("link", mapId.toString());
        this.mongoPrimaryInstance.updateCommonFields(f, this.getResource(), OperationDefinition.OPERATION.SOFT_COPY);
        f.save();
        this.incrementCountField(metaCollectionInstance, mapId);
        return mapId;
    }

    private void incrementCountField(DBCollection metaCollectionInstance, ObjectId mapId) throws UnknownHostException {
        this.logger.info("increment count field on" + mapId + " object map");
        BasicDBObject searchQuery = new BasicDBObject();
        searchQuery.put("_id", mapId);
        DBObject mapObject = this.mongoPrimaryInstance.findCollectionObject(metaCollectionInstance, searchQuery);
        int count = (Integer)mapObject.get("count");
        mapObject.put("count", ++count);
        metaCollectionInstance.save(mapObject);
    }

    private ObjectId getDuplicatesMap(String md5) {
        ObjectId id = this.checkMd5(md5);
        return id;
    }

    private boolean isMap(GridFSDBFile sourceObject) {
        String type = sourceObject.get("type").toString();
        return type.equals("map");
    }

    private ObjectId checkMd5(String md5) {
        return null;
    }

    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    public void setMemoryType(MemoryType memoryType) {
        this.memoryType = memoryType;
    }

    public MongoIOManager getMongoPrimaryInstance() {
        return this.mongoPrimaryInstance;
    }

    public void setMongoPrimaryInstance(MongoIOManager mongoPrimaryInstance) {
        this.mongoPrimaryInstance = mongoPrimaryInstance;
    }

    @Override
    public MyFile getResource() {
        return this.resource;
    }

    @Override
    public void setResource(MyFile resource) {
        this.resource = resource;
    }
}

