/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.gridfs.GridFSDBFile;
import java.io.IOException;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Upload;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadOperator
extends Upload {
    Logger logger = LoggerFactory.getLogger(UploadOperator.class);

    public UploadOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String bck, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, bck, dbs);
    }

    @Override
    public String execute(MongoIOManager mongoPrimaryInstance, MongoIOManager mongoSecondaryInstance, MyFile resource, String bucket, boolean replace) throws IOException {
        OperationDefinition op = resource.getOperationDefinition();
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = resource.getOperation().getRemoteResource();
        this.logger.info("MongoClient put method: " + op.toString());
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        ObjectId id = null;
        ObjectId oldId = null;
        GridFSDBFile fold = mongoPrimaryInstance.retrieveRemoteDescriptor(bucket, remoteResourceIdentifier, false);
        if (fold != null) {
            this.logger.info("a file is already present at: " + this.getBucket());
            oldId = (ObjectId)fold.getId();
            this.logger.info("get old id: " + oldId);
            oldId = mongoPrimaryInstance.removeFile(resource, bucket, replace, oldId, fold);
            if (!this.isReplaceOption()) {
                return oldId.toString();
            }
        }
        this.logger.info("create new file " + bucket);
        id = remoteResourceIdentifier != null && remoteResourceIdentifier.equals((Object)OperationDefinition.REMOTE_RESOURCE.ID) && ObjectId.isValid(this.getBucket()) ? mongoPrimaryInstance.createNewFile(resource, null, dir, name, new ObjectId(this.getBucket())) : mongoPrimaryInstance.createNewFile(resource, this.getBucket(), dir, name, oldId);
        return ((Object)id).toString();
    }

    public String executeSafeMode(MongoIOManager mongoPrimaryInstance, MongoIOManager mongoSecondaryInstance) throws IOException {
        OperationDefinition op = this.resource.getOperationDefinition();
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = this.resource.getOperation().getRemoteResource();
        this.logger.info("MongoClient put method: " + op.toString());
        String dir = this.resource.getRemoteDir();
        String name = this.resource.getName();
        ObjectId id = null;
        ObjectId oldId = null;
        GridFSDBFile fold = mongoPrimaryInstance.retrieveRemoteDescriptor(this.getBucket(), remoteResourceIdentifier, false);
        if (fold != null) {
            this.logger.info("a file is already present at: " + this.getBucket());
            oldId = (ObjectId)fold.getId();
            this.logger.info("get old id: " + oldId);
            id = mongoPrimaryInstance.createNewFile(this.resource, this.getBucket(), dir, name, null);
            oldId = mongoPrimaryInstance.removeFile(this.resource, this.getBucket(), this.isReplaceOption(), oldId, fold);
            id = mongoPrimaryInstance.updateId(id, oldId);
        } else {
            id = mongoPrimaryInstance.createNewFile(this.resource, this.getBucket(), dir, name, oldId);
        }
        return id.toString();
    }
}

