/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.tracing;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.tracing.ThresholdLogReference;
import com.couchbase.client.core.tracing.ThresholdLogScopeManager;
import com.couchbase.client.core.tracing.ThresholdLogSpan;
import com.couchbase.client.core.tracing.ThresholdLogSpanContext;
import com.couchbase.client.core.tracing.ThresholdLogTracer;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ThresholdLogSpanBuilder
implements Tracer.SpanBuilder {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ThresholdLogSpanBuilder.class);
    private final ThresholdLogTracer tracer;
    private String operationName;
    private boolean ignoreActiveSpan;
    private final Map<String, Object> tags;
    private ThresholdLogReference parentRef;
    private ThresholdLogReference followRef;
    private long startTimeMicroseconds;
    private final ThresholdLogScopeManager scopeManager;

    ThresholdLogSpanBuilder(ThresholdLogTracer tracer, String operationName, ThresholdLogScopeManager scopeManager) {
        this.tracer = tracer;
        this.scopeManager = scopeManager;
        this.operationName = operationName;
        this.ignoreActiveSpan = false;
        this.tags = new HashMap<String, Object>();
        this.parentRef = null;
        this.followRef = null;
    }

    @Override
    public ThresholdLogSpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    @Override
    public ThresholdLogSpanBuilder asChildOf(Span parent) {
        return this.addReference("child_of", parent != null ? parent.context() : null);
    }

    @Override
    public ThresholdLogSpanBuilder addReference(String type, SpanContext context) {
        if (!(context instanceof ThresholdLogSpanContext)) {
            LOGGER.debug("The referenced context must be a {}, but was {}", (Object)this.getClass().getName(), (Object)context.getClass().getName());
            return this;
        }
        if (type.equals("child_of")) {
            this.parentRef = ThresholdLogReference.childOf((ThresholdLogSpanContext)context);
        } else if (type.equals("follows_from")) {
            this.followRef = ThresholdLogReference.followsFrom((ThresholdLogSpanContext)context);
        } else {
            LOGGER.debug("Only CHILD_OF and FOLLOWS_FROM are supported. Supplied: {}", (Object)type);
        }
        return this;
    }

    @Override
    public ThresholdLogSpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    @Override
    public ThresholdLogSpanBuilder withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    @Override
    public ThresholdLogSpanBuilder withTag(String key, boolean value) {
        this.tags.put(key, value);
        return this;
    }

    @Override
    public ThresholdLogSpanBuilder withTag(String key, Number value) {
        this.tags.put(key, value);
        return this;
    }

    @Override
    public ThresholdLogSpanBuilder withStartTimestamp(long microseconds) {
        this.startTimeMicroseconds = microseconds;
        return this;
    }

    @Override
    public Scope startActive(boolean finishSpanOnClose) {
        return this.scopeManager.activate(this.start(), finishSpanOnClose);
    }

    @Override
    public Span startManual() {
        return this.start();
    }

    @Override
    public Span start() {
        if (this.parentRef == null && !this.ignoreActiveSpan && null != this.scopeManager.active()) {
            this.asChildOf(this.scopeManager.active().span());
        }
        ThresholdLogSpanContext context = this.parentRef != null ? this.parentRef.spanContext() : (this.followRef != null ? this.followRef.spanContext() : new ThresholdLogSpanContext());
        if (this.startTimeMicroseconds == 0L) {
            this.startTimeMicroseconds = TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
        }
        return new ThresholdLogSpan(this.tracer, context, this.operationName, this.tags, this.startTimeMicroseconds);
    }
}

