/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.io.netty.util.internal.ObjectUtil;

public class ProposedBucketConfigContext {
    private final String bucketName;
    private final String config;
    private final NetworkAddress origin;

    public ProposedBucketConfigContext(String bucketName, String config, NetworkAddress origin) {
        ObjectUtil.checkNotNull(bucketName, "bucket name cannot be null!");
        ObjectUtil.checkNotNull(config, "the raw config cannot be null!");
        this.bucketName = bucketName;
        this.config = config;
        this.origin = origin;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String config() {
        return this.config;
    }

    public NetworkAddress origin() {
        return this.origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProposedBucketConfigContext that = (ProposedBucketConfigContext)o;
        if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        return this.origin != null ? this.origin.equals(that.origin) : that.origin == null;
    }

    public int hashCode() {
        int result = this.bucketName != null ? this.bucketName.hashCode() : 0;
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        return result;
    }
}

