/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ServiceNotAvailableException;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.MathUtils;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class ViewLocator
implements Locator {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ViewLocator.class);
    private static final ServiceNotAvailableException NOT_AVAILABLE = new ServiceNotAvailableException("Views are not available on this bucket type.");
    private final AtomicLong counter;

    public ViewLocator() {
        this(new Random().nextInt(1024));
    }

    ViewLocator(long initialValue) {
        this.counter = new AtomicLong(initialValue);
    }

    @Override
    public void locateAndDispatch(CouchbaseRequest request, List<Node> nodes, ClusterConfig config, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        BucketConfig bucketConfig = config.bucketConfig(request.bucket());
        if (!(bucketConfig instanceof CouchbaseBucketConfig)) {
            request.observable().onError(NOT_AVAILABLE);
            return;
        }
        if ((nodes = this.filterNodes(nodes, (CouchbaseBucketConfig)bucketConfig)).isEmpty()) {
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        int nodeSize = nodes.size();
        int offset = (int)MathUtils.floorMod(this.counter.getAndIncrement(), nodeSize);
        Node node = nodes.get(offset);
        if (node != null) {
            node.send(request);
        } else {
            LOGGER.warn("Locator found selected node to be null, this is a bug. {}, {}", (Object)RedactableArgument.user(request), (Object)RedactableArgument.system(nodes));
            RetryHelper.retryOrCancel(env, request, responseBuffer);
        }
    }

    private List<Node> filterNodes(List<Node> allNodes, CouchbaseBucketConfig cfg) {
        ArrayList<Node> result = new ArrayList<Node>(allNodes.size());
        for (Node n : allNodes) {
            if (!this.checkNode(n, cfg)) continue;
            result.add(n);
        }
        return result;
    }

    protected boolean checkNode(Node node, CouchbaseBucketConfig config) {
        return node.serviceEnabled(ServiceType.VIEW) && config.hasPrimaryPartitionsOnNode(node.hostname());
    }
}

