/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.operation;

import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.IOException;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.operation.DuplicateFile;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateOperator
extends DuplicateFile {
    Logger logger = LoggerFactory.getLogger(DuplicateOperator.class);

    public DuplicateOperator(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String execute(MongoIOManager mongoPrimaryInstance) {
        String destination = this.getResource().getRemotePath() + "-dpl";
        String dir = this.getResource().getRemoteDir();
        if (this.getBucket() != null && !this.getBucket().isEmpty()) {
            OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = this.resource.getOperation().getRemoteResource();
            GridFSDBFile f = mongoPrimaryInstance.retrieveRemoteDescriptor(this.getBucket(), remoteResourceIdentifier, true);
            GridFSFile destinationFile = null;
            try {
                destinationFile = mongoPrimaryInstance.createGFSFileObject(f.getInputStream(), this.resource.getWriteConcern(), this.resource.getReadPreference());
                mongoPrimaryInstance.setGenericProperties(this.getResource(), destination, dir, (GridFSInputFile)destinationFile, destination.substring(destination.lastIndexOf("/") + 1));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String destinationId = destinationFile.getId().toString();
            ((GridFSInputFile)destinationFile).save();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ObjectId: " + destinationId);
            }
            mongoPrimaryInstance.close();
            return destinationId;
        }
        throw new RemoteBackendException("argument cannot be null for duplicate operation");
    }
}

