/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.tracing;

import com.couchbase.client.core.tracing.ThresholdLogReporter;
import com.couchbase.client.core.tracing.ThresholdLogScopeManager;
import com.couchbase.client.core.tracing.ThresholdLogSpan;
import com.couchbase.client.core.tracing.ThresholdLogSpanBuilder;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;

public class ThresholdLogTracer
implements Tracer {
    private final ThresholdLogScopeManager scopeManager = new ThresholdLogScopeManager();
    private final ThresholdLogReporter reporter;

    public static ThresholdLogTracer create() {
        return ThresholdLogTracer.create(ThresholdLogReporter.create());
    }

    public static ThresholdLogTracer create(ThresholdLogReporter reporter) {
        return new ThresholdLogTracer(reporter);
    }

    ThresholdLogTracer() {
        this(ThresholdLogReporter.disabled());
    }

    private ThresholdLogTracer(ThresholdLogReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    @Override
    public Span activeSpan() {
        Scope scope = this.scopeManager.active();
        return scope == null ? null : scope.span();
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new ThresholdLogSpanBuilder(this, operationName, this.scopeManager);
    }

    @Override
    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        throw new UnsupportedOperationException("Not supported by the " + this.getClass().getSimpleName());
    }

    @Override
    public <C> SpanContext extract(Format<C> format, C carrier) {
        throw new UnsupportedOperationException("Not supported by the " + this.getClass().getSimpleName());
    }

    public void reportSpan(ThresholdLogSpan span) {
        this.reporter.report(span);
    }

    public void shutdown() {
        this.reporter.shutdown();
    }
}

