/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.analytics;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.analytics.AnalyticsHandler;
import com.couchbase.client.core.endpoint.analytics.parser.YasjlAnalyticsDeferredResponseParser;
import com.couchbase.client.core.endpoint.analytics.parser.YasjlAnalyticsResponseParser;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.AbstractCouchbaseResponse;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.KeepAlive;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.analytics.AnalyticsQueryResultRequest;
import com.couchbase.client.core.message.analytics.AnalyticsQueryStatusRequest;
import com.couchbase.client.core.message.analytics.AnalyticsRequest;
import com.couchbase.client.core.message.analytics.GenericAnalyticsRequest;
import com.couchbase.client.core.message.analytics.RawAnalyticsRequest;
import com.couchbase.client.core.message.analytics.RawAnalyticsResponse;
import com.couchbase.client.core.message.query.PingRequest;
import com.couchbase.client.core.message.query.PingResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.deps.io.netty.handler.codec.http.LastHttpContent;

public class AnalyticsHandlerV2
extends AbstractGenericHandler<HttpObject, HttpRequest, AnalyticsRequest> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(AnalyticsHandlerV2.class);
    private HttpResponse responseHeader;
    private ByteBuf responseContent;
    private final YasjlAnalyticsResponseParser parser;
    private final YasjlAnalyticsDeferredResponseParser deferredResponseParser;

    public AnalyticsHandlerV2(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, isTransient, pipeline);
        this.deferredResponseParser = new YasjlAnalyticsDeferredResponseParser(this.env().scheduler(), this.env().autoreleaseAfter(), endpoint.environment());
        this.parser = new YasjlAnalyticsResponseParser(this.env().scheduler(), this.env().autoreleaseAfter(), endpoint.environment());
    }

    @Override
    protected HttpRequest encodeRequest(ChannelHandlerContext ctx, AnalyticsRequest msg) throws Exception {
        DefaultFullHttpRequest request;
        if (msg instanceof GenericAnalyticsRequest) {
            GenericAnalyticsRequest queryRequest = (GenericAnalyticsRequest)msg;
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/analytics/service");
            if (queryRequest.isJsonFormat()) {
                request.headers().set("Content-Type", (Object)"application/json");
            }
            if (queryRequest.priority() != 0) {
                request.headers().set("Analytics-Priority", (Object)queryRequest.priority());
            }
            ByteBuf query = ctx.alloc().buffer(((GenericAnalyticsRequest)msg).query().length());
            query.writeBytes(((GenericAnalyticsRequest)msg).query().getBytes(CHARSET));
            request.headers().add("Content-Length", (Object)query.readableBytes());
            request.content().writeBytes(query);
            query.release();
        } else if (msg instanceof com.couchbase.client.core.message.analytics.PingRequest || msg instanceof AnalyticsHandler.KeepAliveRequest || msg instanceof AnalyticsQueryResultRequest || msg instanceof AnalyticsQueryStatusRequest) {
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, msg.path());
        } else {
            throw new IllegalArgumentException("Unknown incoming AnalyticsRequest type " + msg.getClass());
        }
        request.headers().set("User-Agent", (Object)this.env().userAgent());
        request.headers().set("Host", (Object)this.remoteHttpHost(ctx));
        AnalyticsHandlerV2.addHttpBasicAuth(ctx, request, msg.username(), msg.password());
        return request;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        AbstractCouchbaseResponse response = null;
        if (msg instanceof HttpResponse) {
            this.responseHeader = (HttpResponse)msg;
            if (this.responseContent != null) {
                this.responseContent.clear();
            } else {
                this.responseContent = ctx.alloc().buffer();
            }
        }
        if (this.currentRequest() instanceof KeepAliveRequest) {
            if (msg instanceof LastHttpContent) {
                response = new KeepAliveResponse(ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), (CouchbaseRequest)this.currentRequest());
                this.responseContent.clear();
                this.responseContent.discardReadBytes();
                this.finishedDecoding();
            }
        } else if (this.currentRequest() instanceof PingRequest) {
            if (msg instanceof LastHttpContent) {
                response = new PingResponse(ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), (CouchbaseRequest)this.currentRequest());
                this.responseContent.clear();
                this.responseContent.discardReadBytes();
                this.finishedDecoding();
            }
        } else if (msg instanceof HttpContent && this.currentRequest() instanceof AnalyticsQueryResultRequest) {
            this.responseContent.writeBytes(((HttpContent)msg).content());
            boolean lastChunk = msg instanceof LastHttpContent;
            if (!this.deferredResponseParser.isInitialized()) {
                this.deferredResponseParser.initialize(this.responseContent, ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), (CouchbaseRequest)this.currentRequest());
            }
            response = this.deferredResponseParser.parse();
            if (lastChunk) {
                this.deferredResponseParser.finishParsingAndReset();
                this.finishedDecoding();
            }
        } else if (msg instanceof HttpContent) {
            this.responseContent.writeBytes(((HttpContent)msg).content());
            boolean lastChunk = msg instanceof LastHttpContent;
            if (!this.parser.isInitialized()) {
                this.parser.initialize(this.responseContent, ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), (CouchbaseRequest)this.currentRequest());
            }
            if (this.currentRequest() instanceof RawAnalyticsRequest) {
                response = this.handleRawAnalyticsResponse(lastChunk, ctx);
            } else if (this.currentRequest() instanceof GenericAnalyticsRequest || this.currentRequest() instanceof AnalyticsQueryStatusRequest) {
                response = this.parser.parse();
                if (lastChunk) {
                    this.parser.finishParsingAndReset();
                    this.finishedDecoding();
                }
            }
        }
        return response;
    }

    private RawAnalyticsResponse handleRawAnalyticsResponse(boolean lastChunk, ChannelHandlerContext ctx) {
        if (!lastChunk) {
            return null;
        }
        ResponseStatus status = ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code());
        ByteBuf responseCopy = ctx.alloc().buffer(this.responseContent.readableBytes(), this.responseContent.readableBytes());
        responseCopy.writeBytes(this.responseContent);
        return new RawAnalyticsResponse(status, (CouchbaseRequest)this.currentRequest(), responseCopy, this.responseHeader.getStatus().code(), this.responseHeader.getStatus().reasonPhrase());
    }

    @Override
    protected void finishedDecoding() {
        this.releaseResponseContent();
        super.finishedDecoding();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.releaseResponseContent();
        super.handlerRemoved(ctx);
    }

    private void releaseResponseContent() {
        if (this.responseContent != null && this.responseContent.refCnt() > 0) {
            this.responseContent.release();
        }
        this.responseContent = null;
    }

    @Override
    protected CouchbaseRequest createKeepAliveRequest() {
        return new KeepAliveRequest();
    }

    @Override
    protected ServiceType serviceType() {
        return ServiceType.ANALYTICS;
    }

    @InterfaceAudience.Private
    public ByteBuf getResponseContent() {
        return this.responseContent;
    }

    protected static class KeepAliveResponse
    extends AbstractCouchbaseResponse {
        protected KeepAliveResponse(ResponseStatus status, CouchbaseRequest request) {
            super(status, request);
        }
    }

    protected static class KeepAliveRequest
    extends AbstractCouchbaseRequest
    implements AnalyticsRequest,
    KeepAlive {
        protected KeepAliveRequest() {
            super(null, null);
        }

        @Override
        public String path() {
            return "/admin/ping";
        }
    }
}

