/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.analytics.parser;

import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.analytics.GenericAnalyticsResponse;
import com.couchbase.client.core.utils.UnicastAutoReleaseSubject;
import com.couchbase.client.core.utils.yasjl.ByteBufJsonParser;
import com.couchbase.client.core.utils.yasjl.Callbacks.JsonPointerCB1;
import com.couchbase.client.core.utils.yasjl.JsonPointer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.io.EOFException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.subjects.AsyncSubject;

public class YasjlAnalyticsResponseParser {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(YasjlAnalyticsResponseParser.class);
    private static final Charset CHARSET = CharsetUtil.UTF_8;
    private final Scheduler scheduler;
    private final long ttl;
    private final ByteBufJsonParser parser;
    private UnicastAutoReleaseSubject<ByteBuf> queryRowObservable;
    private UnicastAutoReleaseSubject<ByteBuf> querySignatureObservable;
    private UnicastAutoReleaseSubject<ByteBuf> queryErrorObservable;
    private AsyncSubject<String> queryStatusObservable;
    private UnicastAutoReleaseSubject<ByteBuf> queryInfoObservable;
    private UnicastAutoReleaseSubject<ByteBuf> queryProfileInfoObservable;
    private String handle;
    private CouchbaseRequest currentRequest;
    private ResponseStatus status;
    private boolean initialized;
    private GenericAnalyticsResponse response;
    private String requestID;
    private String clientContextID;
    private boolean sentResponse;
    private ByteBuf responseContent;
    private final CoreEnvironment env;

    public YasjlAnalyticsResponseParser(Scheduler scheduler, long ttl, final CoreEnvironment env) {
        this.scheduler = scheduler;
        this.ttl = ttl;
        this.response = null;
        this.env = env;
        JsonPointer[] jsonPointers = new JsonPointer[]{new JsonPointer("/requestID", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                YasjlAnalyticsResponseParser.this.requestID = buf.toString(CHARSET);
                YasjlAnalyticsResponseParser.this.requestID = YasjlAnalyticsResponseParser.this.requestID.substring(1, YasjlAnalyticsResponseParser.this.requestID.length() - 1);
                buf.release();
                if (YasjlAnalyticsResponseParser.this.queryRowObservable != null) {
                    YasjlAnalyticsResponseParser.this.queryRowObservable.withTraceIdentifier("queryRow." + YasjlAnalyticsResponseParser.this.requestID);
                }
                if (YasjlAnalyticsResponseParser.this.queryErrorObservable != null) {
                    YasjlAnalyticsResponseParser.this.queryErrorObservable.withTraceIdentifier("queryError." + YasjlAnalyticsResponseParser.this.requestID);
                }
                if (YasjlAnalyticsResponseParser.this.queryInfoObservable != null) {
                    YasjlAnalyticsResponseParser.this.queryInfoObservable.withTraceIdentifier("queryInfo." + YasjlAnalyticsResponseParser.this.requestID);
                }
                if (YasjlAnalyticsResponseParser.this.querySignatureObservable != null) {
                    YasjlAnalyticsResponseParser.this.querySignatureObservable.withTraceIdentifier("querySignature." + YasjlAnalyticsResponseParser.this.requestID);
                }
                if (YasjlAnalyticsResponseParser.this.queryProfileInfoObservable != null) {
                    YasjlAnalyticsResponseParser.this.queryProfileInfoObservable.withTraceIdentifier("queryProfileInfo." + YasjlAnalyticsResponseParser.this.requestID);
                }
            }
        }), new JsonPointer("/clientContextID", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                YasjlAnalyticsResponseParser.this.clientContextID = buf.toString(CHARSET);
                YasjlAnalyticsResponseParser.this.clientContextID = YasjlAnalyticsResponseParser.this.clientContextID.substring(1, YasjlAnalyticsResponseParser.this.clientContextID.length() - 1);
                buf.release();
            }
        }), new JsonPointer("/signature", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlAnalyticsResponseParser.this.querySignatureObservable != null) {
                    YasjlAnalyticsResponseParser.this.querySignatureObservable.onNext(buf);
                }
            }
        }), new JsonPointer("/status", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlAnalyticsResponseParser.this.queryStatusObservable != null) {
                    String statusStr = buf.toString(CHARSET);
                    buf.release();
                    statusStr = statusStr.substring(1, statusStr.length() - 1);
                    if (!statusStr.equals("success")) {
                        YasjlAnalyticsResponseParser.this.status = ResponseStatus.FAILURE;
                    }
                    YasjlAnalyticsResponseParser.this.queryStatusObservable.onNext(statusStr);
                    if (!YasjlAnalyticsResponseParser.this.sentResponse) {
                        YasjlAnalyticsResponseParser.this.createResponse();
                        LOGGER.trace("Received status for requestId {}", (Object)YasjlAnalyticsResponseParser.this.requestID);
                    }
                }
            }
        }), new JsonPointer("/results/-", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlAnalyticsResponseParser.this.queryRowObservable != null) {
                    YasjlAnalyticsResponseParser.this.queryRowObservable.onNext(buf);
                    if (YasjlAnalyticsResponseParser.this.response == null) {
                        YasjlAnalyticsResponseParser.this.createResponse();
                        LOGGER.trace("Started receiving results for requestId {}", (Object)YasjlAnalyticsResponseParser.this.requestID);
                    }
                }
            }
        }), new JsonPointer("/errors/-", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlAnalyticsResponseParser.this.queryErrorObservable != null) {
                    YasjlAnalyticsResponseParser.this.queryErrorObservable.onNext(buf);
                    if (YasjlAnalyticsResponseParser.this.response == null) {
                        YasjlAnalyticsResponseParser.this.createResponse();
                        LOGGER.trace("Started receiving errors for requestId {}", (Object)YasjlAnalyticsResponseParser.this.requestID);
                    }
                }
            }
        }), new JsonPointer("/warnings/-", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlAnalyticsResponseParser.this.queryErrorObservable != null) {
                    YasjlAnalyticsResponseParser.this.queryErrorObservable.onNext(buf);
                    if (YasjlAnalyticsResponseParser.this.response == null) {
                        YasjlAnalyticsResponseParser.this.createResponse();
                        LOGGER.trace("Started receiving warnings for requestId {}", (Object)YasjlAnalyticsResponseParser.this.requestID);
                    }
                }
            }
        }), new JsonPointer("/profile", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlAnalyticsResponseParser.this.queryProfileInfoObservable != null) {
                    YasjlAnalyticsResponseParser.this.queryProfileInfoObservable.onNext(buf);
                }
            }
        }), new JsonPointer("/metrics", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlAnalyticsResponseParser.this.queryInfoObservable != null) {
                    YasjlAnalyticsResponseParser.this.queryInfoObservable.onNext(buf);
                }
                if (YasjlAnalyticsResponseParser.this.currentRequest.span() != null && env.operationTracingEnabled()) {
                    env.tracer().scopeManager().activate(YasjlAnalyticsResponseParser.this.response.request().span(), true).close();
                }
            }
        }), new JsonPointer("/handle", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                YasjlAnalyticsResponseParser.this.handle = buf.toString(CHARSET).replaceAll("^\"|\"$", "");
                buf.release();
                if (!YasjlAnalyticsResponseParser.this.sentResponse) {
                    YasjlAnalyticsResponseParser.this.createResponse();
                    LOGGER.trace("Received handle for requestId {}", (Object)YasjlAnalyticsResponseParser.this.requestID);
                }
            }
        })};
        this.parser = new ByteBufJsonParser(jsonPointers);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(ByteBuf responseContent, ResponseStatus responseStatus, CouchbaseRequest request) {
        this.requestID = "";
        this.clientContextID = "";
        this.handle = "";
        this.sentResponse = false;
        this.response = null;
        this.status = responseStatus;
        this.responseContent = responseContent;
        this.currentRequest = request;
        this.queryRowObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.queryErrorObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.queryStatusObservable = AsyncSubject.create();
        this.queryInfoObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.querySignatureObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.queryProfileInfoObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.parser.initialize(responseContent);
        this.initialized = true;
    }

    private void createResponse() {
        this.response = new GenericAnalyticsResponse(this.queryErrorObservable.onBackpressureBuffer(), this.queryRowObservable.onBackpressureBuffer(), this.querySignatureObservable.onBackpressureBuffer(), this.queryStatusObservable.onBackpressureBuffer(), this.queryInfoObservable.onBackpressureBuffer(), this.handle, this.currentRequest, this.status, this.requestID, this.clientContextID);
    }

    public GenericAnalyticsResponse parse() throws Exception {
        try {
            this.parser.parse();
            this.responseContent.discardReadBytes();
            LOGGER.trace("Received last chunk and completed parsing for requestId {}", (Object)this.requestID);
        }
        catch (EOFException ex) {
            LOGGER.trace("Still expecting more data for requestId {}", (Object)this.requestID);
        }
        if (!this.sentResponse && this.response != null) {
            this.sentResponse = true;
            return this.response;
        }
        return null;
    }

    public void finishParsingAndReset() {
        if (this.queryRowObservable != null) {
            this.queryRowObservable.onCompleted();
        }
        if (this.queryInfoObservable != null) {
            this.queryInfoObservable.onCompleted();
        }
        if (this.queryErrorObservable != null) {
            this.queryErrorObservable.onCompleted();
        }
        if (this.queryStatusObservable != null) {
            this.queryStatusObservable.onCompleted();
        }
        if (this.querySignatureObservable != null) {
            this.querySignatureObservable.onCompleted();
        }
        if (this.queryProfileInfoObservable != null) {
            this.queryProfileInfoObservable.onCompleted();
        }
        this.queryInfoObservable = null;
        this.queryRowObservable = null;
        this.queryErrorObservable = null;
        this.queryStatusObservable = null;
        this.querySignatureObservable = null;
        this.queryProfileInfoObservable = null;
        this.initialized = false;
    }
}

