/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv;

import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactionLevel;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.concurrent.atomic.AtomicInteger;
import rx.subjects.AsyncSubject;
import rx.subjects.Subject;

public abstract class AbstractKeyValueRequest
extends AbstractCouchbaseRequest
implements BinaryRequest {
    private static final AtomicInteger GLOBAL_OPAQUE = new AtomicInteger(0);
    protected static final short DEFAULT_PARTITION = -1;
    private static final RedactionLevel REDACTION_LEVEL = CouchbaseLoggerFactory.getRedactionLevel();
    private final byte[] keyBytes;
    private final String key;
    private short partition = (short)-1;
    private final int opaque;

    protected AbstractKeyValueRequest(String key, String bucket) {
        this(key, bucket, null, null, AsyncSubject.create());
    }

    protected AbstractKeyValueRequest(String key, String bucket, String password) {
        this(key, bucket, bucket, password, AsyncSubject.create());
    }

    protected AbstractKeyValueRequest(String key, String bucket, String username, String password) {
        this(key, bucket, username, password, AsyncSubject.create());
    }

    protected AbstractKeyValueRequest(String key, String bucket, String username, String password, Subject<CouchbaseResponse, CouchbaseResponse> observable) {
        super(bucket, username, password, observable);
        this.key = key;
        this.keyBytes = key == null || key.isEmpty() ? new byte[]{} : key.getBytes(CharsetUtil.UTF_8);
        this.opaque = GLOBAL_OPAQUE.getAndIncrement();
    }

    @Override
    protected void afterSpanSet(Span span) {
        span.setTag(Tags.PEER_SERVICE.getKey(), "kv");
        if (REDACTION_LEVEL == RedactionLevel.NONE) {
            span.setTag("couchbase.document_key", this.key);
        }
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public byte[] keyBytes() {
        return this.keyBytes;
    }

    @Override
    public short partition() {
        if (this.partition == -1) {
            throw new IllegalStateException("Partition requested but not set beforehand");
        }
        return this.partition;
    }

    @Override
    public BinaryRequest partition(short partition) {
        if (partition < 0) {
            throw new IllegalArgumentException("Partition must be larger than or equal to zero");
        }
        this.partition = partition;
        return this;
    }

    @Override
    public int opaque() {
        return this.opaque;
    }

    @Override
    public String operationId() {
        return "0x" + Integer.toHexString(this.opaque);
    }
}

