/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.config.BucketConfigRequest;
import com.couchbase.client.core.message.config.GetDesignDocumentsRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class ConfigLocator
implements Locator {
    private final AtomicLong counter;

    public ConfigLocator() {
        this(new Random().nextInt(1024));
    }

    ConfigLocator(long initialValue) {
        this.counter = new AtomicLong(initialValue);
    }

    @Override
    public void locateAndDispatch(CouchbaseRequest request, List<Node> nodes, ClusterConfig config, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        if (request instanceof BucketConfigRequest && ((BucketConfigRequest)request).hostname() != null) {
            BucketConfigRequest req = (BucketConfigRequest)request;
            String hostname = req.hostname();
            for (Node node : nodes) {
                if (!node.hostname().equals(hostname)) continue;
                node.send(request);
                return;
            }
        } else {
            Node node;
            int offset;
            int i;
            int nodeSize = nodes.size();
            if (nodeSize <= 0) {
                RetryHelper.retryOrCancel(env, request, responseBuffer);
                return;
            }
            for (i = offset = (int)this.counter.getAndIncrement() % nodeSize; i < nodeSize; ++i) {
                node = nodes.get(i);
                if (!this.checkNode(node, request)) continue;
                node.send(request);
                return;
            }
            for (i = 0; i < offset; ++i) {
                node = nodes.get(i);
                if (!this.checkNode(node, request)) continue;
                node.send(request);
                return;
            }
        }
        RetryHelper.retryOrCancel(env, request, responseBuffer);
    }

    private boolean checkNode(Node node, CouchbaseRequest request) {
        if (request instanceof GetDesignDocumentsRequest) {
            return node.serviceEnabled(ServiceType.VIEW);
        }
        return node.serviceEnabled(ServiceType.CONFIG);
    }
}

