/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.DiagnosticRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigResponse;
import com.couchbase.client.core.message.internal.PingReport;
import com.couchbase.client.core.message.internal.PingServiceHealth;
import com.couchbase.client.core.message.kv.NoopRequest;
import com.couchbase.client.core.message.kv.NoopResponse;
import com.couchbase.client.core.message.search.PingRequest;
import com.couchbase.client.core.message.search.PingResponse;
import com.couchbase.client.core.service.ServiceType;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Single;
import rx.functions.Func0;
import rx.functions.Func1;

public class HealthPinger {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(HealthPinger.class);

    public static Single<PingReport> ping(final CoreEnvironment env, final String bucket, final String password, final ClusterFacade core, final String id, final long timeout, final TimeUnit timeUnit, ServiceType ... types) {
        if (types == null || types.length == 0) {
            types = new ServiceType[]{ServiceType.BINARY, ServiceType.ANALYTICS, ServiceType.QUERY, ServiceType.SEARCH, ServiceType.VIEW};
        }
        final EnumSet<ServiceType> typeSet = EnumSet.copyOf(Arrays.asList(types));
        return Observable.defer(new Func0<Observable<GetClusterConfigResponse>>(){

            @Override
            public Observable<GetClusterConfigResponse> call() {
                return core.send(new GetClusterConfigRequest());
            }
        }).map(new Func1<GetClusterConfigResponse, BucketConfig>(){

            @Override
            public BucketConfig call(GetClusterConfigResponse res) {
                return res.config().bucketConfig(bucket);
            }
        }).flatMap(new Func1<BucketConfig, Observable<PingReport>>(){

            @Override
            public Observable<PingReport> call(final BucketConfig config) {
                ArrayList<Observable> services = new ArrayList<Observable>();
                for (NodeInfo ni : config.nodes()) {
                    block8: for (ServiceType type : ni.services().keySet()) {
                        if (!typeSet.contains((Object)type)) continue;
                        switch (type) {
                            case BINARY: {
                                services.add(HealthPinger.pingBinary(ni.hostname(), bucket, core, timeout, timeUnit));
                                continue block8;
                            }
                            case ANALYTICS: {
                                services.add(HealthPinger.pingAnalytics(ni.hostname(), bucket, password, core, timeout, timeUnit));
                                continue block8;
                            }
                            case QUERY: {
                                services.add(HealthPinger.pingQuery(ni.hostname(), bucket, password, core, timeout, timeUnit));
                                continue block8;
                            }
                            case SEARCH: {
                                services.add(HealthPinger.pingSearch(ni.hostname(), bucket, password, core, timeout, timeUnit));
                                continue block8;
                            }
                            case VIEW: {
                                services.add(HealthPinger.pingViews(ni.hostname(), bucket, password, core, timeout, timeUnit));
                                continue block8;
                            }
                        }
                        throw new IllegalStateException("Unknown type " + (Object)((Object)type));
                    }
                }
                return Observable.merge(services).toList().map(new Func1<List<PingServiceHealth>, PingReport>(){

                    @Override
                    public PingReport call(List<PingServiceHealth> services) {
                        return new PingReport(services, env.userAgent(), id, config.rev());
                    }
                });
            }
        }).toSingle();
    }

    private static Observable<PingServiceHealth> pingBinary(final String hostname, final String bucket, final ClusterFacade core, long timeout, TimeUnit timeUnit) {
        final AtomicReference<CouchbaseRequest> request = new AtomicReference<CouchbaseRequest>();
        Observable<NoopResponse> response = Observable.defer(new Func0<Observable<NoopResponse>>(){

            @Override
            public Observable<NoopResponse> call() {
                NoopRequest r = new NoopRequest(bucket, hostname);
                request.set(r);
                return core.send(r);
            }
        }).timeout(timeout, timeUnit);
        return HealthPinger.mapToServiceHealth(bucket, ServiceType.BINARY, response, request, timeout, timeUnit);
    }

    private static Observable<PingServiceHealth> mapToServiceHealth(final String scope, final ServiceType type, Observable<? extends CouchbaseResponse> input, final AtomicReference<CouchbaseRequest> request, final long timeout, final TimeUnit timeUnit) {
        return input.map(new Func1<CouchbaseResponse, PingServiceHealth>(){

            @Override
            public PingServiceHealth call(CouchbaseResponse response) {
                DiagnosticRequest request = (DiagnosticRequest)((Object)response.request());
                String id = "0x" + Integer.toHexString(request.localSocket().hashCode());
                return new PingServiceHealth(type, PingServiceHealth.PingState.OK, id, TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - response.request().creationTime()), request.localSocket(), request.remoteSocket(), scope);
            }
        }).onErrorReturn(new Func1<Throwable, PingServiceHealth>(){

            @Override
            public PingServiceHealth call(Throwable throwable) {
                String id;
                SocketAddress local = ((DiagnosticRequest)request.get()).localSocket();
                SocketAddress remote = ((DiagnosticRequest)request.get()).remoteSocket();
                String string = id = local == null ? "0x0000" : "0x" + Integer.toHexString(local.hashCode());
                if (throwable instanceof TimeoutException) {
                    return new PingServiceHealth(type, PingServiceHealth.PingState.TIMEOUT, id, timeUnit.toMicros(timeout), local, remote, scope);
                }
                LOGGER.warn("Error while running PingService for {}", (Object)type, (Object)throwable);
                return new PingServiceHealth(type, PingServiceHealth.PingState.ERROR, id, TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - ((CouchbaseRequest)request.get()).creationTime()), local, remote, scope);
            }
        });
    }

    private static Observable<PingServiceHealth> pingQuery(final String hostname, final String bucket, final String password, final ClusterFacade core, long timeout, TimeUnit timeUnit) {
        final AtomicReference<CouchbaseRequest> request = new AtomicReference<CouchbaseRequest>();
        Observable<com.couchbase.client.core.message.query.PingResponse> response = Observable.defer(new Func0<Observable<com.couchbase.client.core.message.query.PingResponse>>(){

            @Override
            public Observable<com.couchbase.client.core.message.query.PingResponse> call() {
                com.couchbase.client.core.message.query.PingRequest r;
                try {
                    r = new com.couchbase.client.core.message.query.PingRequest(hostname, bucket, password);
                }
                catch (Exception e) {
                    return Observable.error(e);
                }
                request.set(r);
                return core.send(r);
            }
        }).timeout(timeout, timeUnit);
        return HealthPinger.mapToServiceHealth(null, ServiceType.QUERY, response, request, timeout, timeUnit);
    }

    private static Observable<PingServiceHealth> pingSearch(final String hostname, final String bucket, final String password, final ClusterFacade core, long timeout, TimeUnit timeUnit) {
        final AtomicReference<CouchbaseRequest> request = new AtomicReference<CouchbaseRequest>();
        Observable<PingResponse> response = Observable.defer(new Func0<Observable<PingResponse>>(){

            @Override
            public Observable<PingResponse> call() {
                PingRequest r;
                try {
                    r = new PingRequest(hostname, bucket, password);
                }
                catch (Exception e) {
                    return Observable.error(e);
                }
                request.set(r);
                return core.send(r);
            }
        }).timeout(timeout, timeUnit);
        return HealthPinger.mapToServiceHealth(null, ServiceType.SEARCH, response, request, timeout, timeUnit);
    }

    private static Observable<PingServiceHealth> pingViews(final String hostname, final String bucket, final String password, final ClusterFacade core, long timeout, TimeUnit timeUnit) {
        final AtomicReference<CouchbaseRequest> request = new AtomicReference<CouchbaseRequest>();
        Observable<com.couchbase.client.core.message.view.PingResponse> response = Observable.defer(new Func0<Observable<com.couchbase.client.core.message.view.PingResponse>>(){

            @Override
            public Observable<com.couchbase.client.core.message.view.PingResponse> call() {
                com.couchbase.client.core.message.view.PingRequest r;
                try {
                    r = new com.couchbase.client.core.message.view.PingRequest(hostname, bucket, password);
                }
                catch (Exception e) {
                    return Observable.error(e);
                }
                request.set(r);
                return core.send(r);
            }
        }).timeout(timeout, timeUnit);
        return HealthPinger.mapToServiceHealth(null, ServiceType.VIEW, response, request, timeout, timeUnit);
    }

    private static Observable<PingServiceHealth> pingAnalytics(final String hostname, final String bucket, final String password, final ClusterFacade core, long timeout, TimeUnit timeUnit) {
        final AtomicReference<CouchbaseRequest> request = new AtomicReference<CouchbaseRequest>();
        Observable<com.couchbase.client.core.message.analytics.PingResponse> response = Observable.defer(new Func0<Observable<com.couchbase.client.core.message.analytics.PingResponse>>(){

            @Override
            public Observable<com.couchbase.client.core.message.analytics.PingResponse> call() {
                com.couchbase.client.core.message.analytics.PingRequest r;
                try {
                    r = new com.couchbase.client.core.message.analytics.PingRequest(hostname, bucket, password);
                }
                catch (Exception e) {
                    return Observable.error(e);
                }
                request.set(r);
                return core.send(r);
            }
        }).timeout(timeout, timeUnit);
        return HealthPinger.mapToServiceHealth(null, ServiceType.ANALYTICS, response, request, timeout, timeUnit);
    }
}

