/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.transport.backend.BsonOperator;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.Costants;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.DateUtils;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.MongoInputStream;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.MongoOutputStream;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoIOManager {
    private DB db;
    private String[] server;
    private MongoClient mongo;
    private String user;
    private String password;
    private Logger logger = LoggerFactory.getLogger(MongoIOManager.class);
    private GridFS gfs;
    private MemoryType memoryType;
    private String dbName;
    protected String writeConcern;
    protected String readPreference;

    protected MongoIOManager(String[] server, String user, String password, MemoryType memoryType, String dbName, String writeConcern, String readPreference) {
        this.setServer(server);
        this.setUser(user);
        this.setPassword(password);
        this.setMemoryType(memoryType);
        this.setDbName(dbName);
        this.setWriteConcern(writeConcern);
        this.setReadPreference(readPreference);
    }

    public DB getConnectionDB(String dbName, boolean readwritePreferences) {
        if (this.db == null) {
            try {
                ArrayList<ServerAddress> srvList = new ArrayList<ServerAddress>();
                for (String srv : this.server) {
                    srvList.add(new ServerAddress(srv));
                }
                if (this.mongo == null) {
                    this.logger.debug(" open mongo connection ");
                    MongoClientOptions options = null;
                    options = !Utils.isVarEnv("NO-SSL") && "SSL".equalsIgnoreCase("SSL") ? MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).connectionsPerHost(30).connectTimeout(30000).build() : ("SSL".equalsIgnoreCase("NO-SSL") || Utils.checkVarEnv("NO-SSL").equalsIgnoreCase("TRUE") ? MongoClientOptions.builder().connectionsPerHost(30).connectTimeout(30000).build() : MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).connectionsPerHost(30).connectTimeout(30000).build());
                    if (this.password != null && this.password.length() > 0 && this.user != null && this.user.length() > 0) {
                        MongoCredential credential = MongoCredential.createCredential(this.user, dbName, this.password.toCharArray());
                        this.mongo = new MongoClient(srvList, Arrays.asList(credential), options);
                    } else {
                        this.mongo = new MongoClient(srvList, options);
                    }
                    this.logger.debug("Istantiate MongoDB with options: " + this.mongo.getMongoClientOptions());
                }
                this.db = this.mongo.getDB(dbName);
                if (readwritePreferences && this.memoryType != MemoryType.VOLATILE && srvList.size() > 1) {
                    if (this.writeConcern != null) {
                        WriteConcern write = new WriteConcern(Integer.parseInt(this.writeConcern));
                        this.db.setWriteConcern(write);
                    } else {
                        this.db.setWriteConcern(Costants.DEFAULT_WRITE_TYPE);
                    }
                    if (this.readPreference != null) {
                        ReadPreference read = ReadPreference.valueOf(this.readPreference);
                        this.db.setReadPreference(read);
                    } else {
                        this.db.setReadPreference(Costants.DEFAULT_READ_PREFERENCE);
                    }
                }
            }
            catch (Exception e) {
                this.close();
                this.logger.error("Problem to open the DB connection for gridfs file ");
                throw new RemoteBackendException("Problem to open the DB connection: " + e.getMessage());
            }
            this.logger.info("new mongo connection pool opened");
        }
        return this.db;
    }

    protected ObjectId getRemoteObject(GridFS gfs, MyFile resource, GridFSDBFile f) throws IOException, IllegalAccessError {
        ObjectId id = (ObjectId)f.getId();
        String lock = (String)f.get("lock");
        if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
            if (f.containsField("lock") && f.get("lock") != null) {
                f.put("lock", null);
                f.save();
            }
            this.download(gfs, resource, f, false);
        } else {
            this.checkTTL(f);
        }
        return id;
    }

    public ObjectId getRemoteObject(MyFile resource, GridFSDBFile f) throws IOException, IllegalAccessError {
        ObjectId id = (ObjectId)f.getId();
        String lock = (String)f.get("lock");
        if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
            if (f.containsField("lock") && f.get("lock") != null) {
                f.put("lock", null);
                f.save();
            }
            this.download(resource, f, false);
        } else {
            this.checkTTL(f);
        }
        return id;
    }

    @Deprecated
    public boolean isTTLUnlocked(GridFSDBFile f) {
        if (f.get("timestamp") == null) {
            return true;
        }
        long timestamp = (Long)f.get("timestamp");
        this.logger.debug("timestamp found: " + timestamp);
        if (timestamp != 0L) {
            long currentTTL = System.currentTimeMillis() - timestamp;
            this.logger.debug("currentTTL: " + currentTTL + " TTL stabilito: " + 180000L);
            if (180000L < currentTTL) {
                f.put("timestamp", null);
                return true;
            }
            return false;
        }
        return true;
    }

    private void download(GridFS gfs, MyFile resource, GridFSDBFile f, boolean isLock) throws IOException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient download method: " + op.toString());
        while (f != null && f.containsField("link") && f.get("link") != null) {
            BasicDBObject query = new BasicDBObject();
            query.put("_id", new ObjectId((String)f.get("link")));
            f = gfs.findOne(query);
        }
        this.updateCommonFields(f, resource, OperationDefinition.OPERATION.DOWNLOAD);
        f.save();
        if (resource.getLocalPath() != null && !resource.getLocalPath().isEmpty()) {
            this.readByPath(resource, f, isLock, 0);
            this.close();
        } else if (resource.getOutputStream() != null) {
            this.readByOutputStream(resource, f, isLock, 0);
            this.close();
        }
        if (resource != null && resource.getType() != null && resource.getType().equalsIgnoreCase("input")) {
            this.readByInputStream(resource, f, isLock, 0);
        }
    }

    private void download(MyFile resource, GridFSDBFile f, boolean isLock) throws IOException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient download method: " + op.toString());
        while (f != null && f.containsField("link") && f.get("link") != null) {
            BasicDBObject query = new BasicDBObject();
            query.put("_id", new ObjectId((String)f.get("link")));
            f = this.getGfs().findOne(query);
        }
        this.updateCommonFields(f, resource, OperationDefinition.OPERATION.DOWNLOAD);
        f.save();
        if (resource.getLocalPath() != null && !resource.getLocalPath().isEmpty()) {
            this.readByPath(resource, f, isLock, 0);
            this.close();
        } else if (resource.getOutputStream() != null) {
            this.readByOutputStream(resource, f, isLock, 0);
            this.close();
        }
        if (resource != null && resource.getType() != null && resource.getType().equalsIgnoreCase("input")) {
            this.readByInputStream(resource, f, isLock, 0);
        }
    }

    public void updateCommonFields(DBObject f, MyFile resource, OperationDefinition.OPERATION op) {
        f.put("lastAccess", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
        String owner = resource.getOwner();
        f.put("lastUser", owner);
        if (op == null) {
            op = resource.getOperationDefinition().getOperation();
        }
        this.logger.info("set last operation: " + (Object)((Object)op));
        f.put("lastOperation", op.toString());
        if (op.toString().equalsIgnoreCase(OperationDefinition.OPERATION.MOVE.toString())) {
            f.put("from", resource.getLocalPath());
        }
        String address = null;
        try {
            address = InetAddress.getLocalHost().getCanonicalHostName().toString();
            f.put("callerIP", address);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public ObjectId removeFile(Object resource, String key, boolean replace, ObjectId oldId, GridFSDBFile fold) throws IllegalAccessError, UnknownHostException {
        String lock;
        this.logger.info("removing object with id: " + resource);
        String oldir = (String)fold.get("dir");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("old dir  found " + oldir);
        }
        this.logger.info("remove old object if replace is true and the file is not locked");
        if (!replace) {
            return oldId;
        }
        if (fold.containsField("count") && fold.get("count") != null) {
            this.close();
            throw new RemoteBackendException("The file cannot be replaced because is linked from another remote file");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remove id: " + oldId);
        }
        if (!((lock = (String)fold.get("lock")) == null || lock.isEmpty() || this.isTTLUnlocked(fold) || lock.equalsIgnoreCase(key))) {
            this.close();
            throw new IllegalAccessError("The file is locked");
        }
        oldId = this.checkAndRemove(fold, (MyFile)resource);
        return oldId;
    }

    public ObjectId checkAndRemove(GridFSDBFile f, MyFile resource) {
        String idToRemove = f.getId().toString();
        this.logger.info("check and remove object with id " + idToRemove + " and path: " + f.get("filename"));
        ObjectId idFile = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("fileFound\t remove file");
        }
        this.updateCommonFields(f, resource, OperationDefinition.OPERATION.REMOVE);
        if (f != null && f.containsField("count") && f.get("count") != null) {
            String filename = (String)f.get("filename");
            f.put("onScope", filename);
            f.put("dir", null);
            f.put("filename", null);
            f.put("name", null);
            f.put("onDeleting", "true");
            f.save();
        } else if (f.containsField("link") && f.get("link") != null) {
            while (f != null && f.containsField("link") && f.get("link") != null) {
                ObjectId oId;
                String id = (String)f.get("link");
                GridFSDBFile fLink = this.findGFSCollectionObject(new ObjectId(id));
                int linkCount = (Integer)fLink.get("count");
                if (--linkCount == 0) {
                    if (fLink.get("name") == null && fLink.get("filename") == null && fLink.get("dir") == null) {
                        ObjectId idLink;
                        ObjectId idF;
                        idFile = idF = (ObjectId)f.getId();
                        this.removeGFSFile(f, idF);
                        if (fLink.containsField("link") && fLink.get("link") != null) {
                            id = (String)fLink.get("link");
                            f = this.findGFSCollectionObject(new ObjectId(id));
                        } else {
                            f = null;
                        }
                        idFile = idLink = (ObjectId)fLink.getId();
                        this.removeGFSFile(fLink, idLink);
                        continue;
                    }
                    fLink.put("count", null);
                    fLink.save();
                    idFile = oId = (ObjectId)f.getId();
                    this.removeGFSFile(f, oId);
                    f = null;
                    continue;
                }
                fLink.put("count", linkCount);
                fLink.save();
                idFile = oId = (ObjectId)f.getId();
                this.removeGFSFile(f, oId);
                f = null;
            }
        } else {
            this.logger.info("removing file with id: " + idToRemove);
            idFile = new ObjectId(idToRemove);
            this.removeGFSFile(f, new ObjectId(idToRemove));
        }
        return idFile;
    }

    public void checkTTL(GridFSDBFile f) throws IllegalAccessError {
        if (f.containsField("timestamp") && f.get("timestamp") != null) {
            long timestamp = (Long)f.get("timestamp");
            long currentTTL = System.currentTimeMillis() - timestamp;
            this.close();
            throw new IllegalAccessError("the file is locked currentTTL: " + currentTTL + "TTL bound " + 180000L);
        }
        this.checkTTL(f);
    }

    public ObjectId createNewFile(Object resource, String bucket, String dir, String name, ObjectId oldId) throws UnknownHostException {
        if (dir != null && !dir.isEmpty() && bucket != null && !bucket.isEmpty()) {
            this.buildDirTree(this.getMetaDataCollection(null), dir);
        }
        GridFSInputFile f2 = this.writePayload(resource, 0, bucket, name, dir, oldId);
        ObjectId id = (ObjectId)f2.getId();
        this.logger.info("new file created with id: " + id);
        return id;
    }

    protected GridFSInputFile writePayload(Object resource, int count, String bucket, String name, String dir, ObjectId idFile) {
        GridFSInputFile f2 = null;
        try {
            if (((MyFile)resource).getInputStream() != null) {
                f2 = this.writeByInputStream(resource, bucket, name, dir, idFile);
                f2.save();
            } else if (((MyFile)resource).getType() != null && ((MyFile)resource).getType().equals("output")) {
                f2 = this.writeByOutputStream(resource, bucket, name, dir, idFile);
            } else {
                f2 = this.writeByLocalFilePath(resource, bucket, name, dir, idFile);
                f2.save();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Directory: " + dir);
            }
            Object id = f2.getId();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ObjectId: " + id);
            }
            if (((MyFile)resource).getType() == null || !((MyFile)resource).getType().equals("output")) {
                this.close();
            }
        }
        catch (IOException e1) {
            this.logger.error("Connection error. " + e1.getMessage());
            if (count < 5) {
                this.logger.info(" Retry : #" + ++count);
                this.writePayload(resource, count, bucket, name, dir, idFile);
            }
            this.logger.error("max number of retry completed ");
            this.close();
            throw new RemoteBackendException(e1);
        }
        return f2;
    }

    protected GridFSInputFile writeByLocalFilePath(Object resource, String bucket, String name, String dir, ObjectId idFile) throws IOException {
        GridFSInputFile f2 = this.memoryType != MemoryType.VOLATILE ? this.createGFSFileObject(new File(((MyFile)resource).getLocalPath()), ((MyFile)resource).getWriteConcern(), ((MyFile)resource).getReadPreference()) : this.createGFSFileObject(new File(((MyFile)resource).getLocalPath()));
        this.fillInputFile(resource, bucket, name, dir, f2, idFile);
        this.saveGFSFileObject(f2);
        return f2;
    }

    protected GridFSInputFile writeByOutputStream(Object resource, String bucket, String name, String dir, ObjectId idFile) throws IOException {
        GridFSInputFile f2 = this.memoryType != MemoryType.VOLATILE ? this.createGFSFileObject(((MyFile)resource).getName(), ((MyFile)resource).getWriteConcern(), ((MyFile)resource).getReadPreference()) : this.createGFSFileObject(((MyFile)resource).getName());
        this.fillInputFile(resource, bucket, name, dir, f2, idFile);
        ((MyFile)resource).setOutputStream(new MongoOutputStream(this.mongo, f2.getOutputStream()));
        return f2;
    }

    protected GridFSInputFile writeByInputStream(Object resource, String bucket, String name, String dir, ObjectId idFile) throws IOException {
        GridFSInputFile f2 = this.memoryType != MemoryType.VOLATILE ? this.createGFSFileObject(((MyFile)resource).getInputStream(), ((MyFile)resource).getWriteConcern(), ((MyFile)resource).getReadPreference()) : this.createGFSFileObject(((MyFile)resource).getInputStream());
        this.fillInputFile(resource, bucket, name, dir, f2, idFile);
        this.saveGFSFileObject(f2);
        ((MyFile)resource).getInputStream().close();
        ((MyFile)resource).setInputStream(null);
        return f2;
    }

    protected void fillInputFile(Object resource, String bucket, String name, String dir, GridFSInputFile f2, ObjectId id) {
        String mime;
        if (id != null) {
            f2.put("_id", new ObjectId(id.toString()));
        }
        if (bucket != null && bucket.contains("/")) {
            f2.put("filename", bucket);
        }
        f2.put("type", "file");
        if (name != null) {
            f2.put("name", name);
        }
        if (dir != null) {
            f2.put("dir", dir);
        }
        if (((MyFile)resource).getOwner() != null) {
            f2.put("owner", ((MyFile)resource).getOwner());
        }
        if ((mime = ((MyFile)resource).getMimeType()) != null) {
            f2.put("mimetype", mime);
        }
        f2.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
        this.updateCommonFields(f2, (MyFile)resource, null);
    }

    protected void removeObject(GridFS gfs, BasicDBObject query, MyFile resource) {
        List<GridFSDBFile> list = gfs.find(query);
        for (GridFSDBFile f : list) {
            if (f != null) {
                this.checkAndRemove(f, resource);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("File Not Found");
        }
    }

    public void setGenericProperties(MyFile resource, String destination, String dir, GridFSInputFile destinationFile, String name) {
        this.updateCommonFields(destinationFile, resource, null);
        destinationFile.put("filename", destination);
        destinationFile.put("type", "file");
        destinationFile.put("name", name);
        destinationFile.put("dir", dir);
        destinationFile.put("owner", resource.getOwner());
        destinationFile.put("mimetype", resource.getMimeType());
        destinationFile.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
    }

    public BasicDBObject setGenericMoveProperties(MyFile resource, String filename, String dir, String name, BasicDBObject f) {
        f.append("filename", filename).append("type", "file").append("name", name).append("dir", dir);
        return f;
    }

    public ObjectId updateId(ObjectId oldId, ObjectId newId) throws UnknownHostException {
        this.logger.info("retrieve object with id: " + oldId);
        this.updateChunksCollection(oldId, newId);
        this.replaceObjectIDOnMetaCollection(oldId, newId);
        return newId;
    }

    protected void replaceObjectIDOnMetaCollection(ObjectId oldId, ObjectId newId) throws UnknownHostException {
        BasicDBObject oldIdQuery = new BasicDBObject();
        oldIdQuery.put("_id", oldId);
        String collectionName = "fs.files";
        DBCollection dbc = this.getCollection(null, collectionName);
        DBObject obj = this.findCollectionObject(dbc, oldIdQuery);
        obj.put("_id", newId);
        if (this.memoryType != MemoryType.VOLATILE) {
            dbc.remove((DBObject)oldIdQuery, Costants.DEFAULT_WRITE_TYPE);
            dbc.insert(obj, Costants.DEFAULT_WRITE_TYPE);
        } else {
            dbc.remove(oldIdQuery);
            dbc.insert(obj);
        }
    }

    public void updateChunksCollection(ObjectId oldId, ObjectId newId) throws UnknownHostException {
        this.logger.info("update chunks collection. Change file_id from " + oldId + " to " + newId);
        BasicDBObject searchQuery = new BasicDBObject().append("files_id", oldId);
        BasicDBObject queryNewFileId = new BasicDBObject().append("$set", new BasicDBObject().append("files_id", newId));
        String chunksCollectionName = "fs.chunks";
        DBCollection dbc = this.getCollection(null, chunksCollectionName);
        dbc.update(searchQuery, queryNewFileId, true, true);
    }

    protected DBCollection getMetaDataCollection() throws UnknownHostException {
        if (this.db == null) {
            this.db = this.getConnectionDB(this.dbName, true);
        }
        return this.db.getCollection("fs.files");
    }

    public DBCollection getMetaDataCollection(DB db) throws UnknownHostException {
        if (db == null) {
            this.db = this.getConnectionDB(this.dbName, true);
            return this.db.getCollection("fs.files");
        }
        return db.getCollection("fs.files");
    }

    protected DBCollection getCollection(DB db, String collectionName) throws UnknownHostException {
        if (db == null) {
            this.db = this.getConnectionDB(this.dbName, false);
            return this.db.getCollection(collectionName);
        }
        return db.getCollection(collectionName);
    }

    public GridFSDBFile retrieveRemoteDescriptor(String serverLocation, OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier, boolean retry) {
        this.logger.info("MongoDB - retrieve object from pathServer: " + serverLocation);
        GridFSDBFile f = null;
        try {
            GridFS gfs = new GridFS(this.getConnectionDB(this.dbName, true));
            if (ObjectId.isValid(serverLocation)) {
                try {
                    BasicDBObject query = new BasicDBObject();
                    query.put("_id", new ObjectId(serverLocation));
                    f = gfs.findOne(query);
                }
                catch (Exception e) {
                    this.logger.warn("the file " + serverLocation + " is not a valid objectId " + e.getMessage());
                    f = null;
                }
                if (retry && f == null) {
                    int i = 0;
                    while (f == null && i < 5) {
                        this.logger.info(" retry to search file " + serverLocation);
                        Thread.sleep(500L);
                        try {
                            BasicDBObject query = new BasicDBObject();
                            query.put("_id", new ObjectId(serverLocation));
                            f = gfs.findOne(query);
                            ++i;
                        }
                        catch (Exception e) {
                            this.logger.warn("the file " + serverLocation + " is not a valid objectId " + e.getMessage());
                            f = null;
                        }
                    }
                } else if (remoteResourceIdentifier != null && !remoteResourceIdentifier.equals((Object)OperationDefinition.REMOTE_RESOURCE.ID) && f == null) {
                    f = gfs.findOne(serverLocation);
                    f = this.retryAsAPath(serverLocation, true, f, gfs);
                }
            } else {
                this.logger.info("remote object is not a validID : " + serverLocation);
                f = gfs.findOne(serverLocation);
                f = this.retryAsAPath(serverLocation, retry, f, gfs);
            }
            if (f == null) {
                f = this.patchRemoteFilePathVersion1(serverLocation, gfs);
            }
            if (f != null) {
                this.logger.info("object found " + f.get("name"));
            } else {
                this.logger.info("object not found ");
            }
        }
        catch (Exception e) {
            this.logger.error("problem retrieving remote object: " + serverLocation + " " + e.getMessage());
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return f;
    }

    private GridFSDBFile retryAsAPath(String serverLocation, boolean retry, GridFSDBFile f, GridFS gfs) throws InterruptedException {
        if (retry && f == null) {
            for (int i = 0; f == null && i < 5; ++i) {
                this.logger.info(" retry to search file as a path" + serverLocation);
                Thread.sleep(500L);
                f = gfs.findOne(serverLocation);
            }
        }
        return f;
    }

    protected List<GridFSDBFile> retrieveRemoteObjects(BasicDBObject query) throws UnknownHostException {
        GridFS gfs = this.getGfs();
        return gfs.find(query);
    }

    public GridFSDBFile retrieveLinkPayload(GridFSDBFile f) throws UnknownHostException {
        while (f.containsField("link") && f.get("link") != null) {
            String id = (String)f.get("link");
            f = this.getGfs().find(new ObjectId(id));
        }
        return f;
    }

    private GridFSDBFile patchRemoteFilePathVersion1(String serverLocation, GridFS gfs) {
        GridFSDBFile f = null;
        String path = serverLocation;
        String locationV1 = null;
        if (serverLocation.contains("/home/null/")) {
            locationV1 = path.replace("/home/null/", "/public/");
            f = gfs.findOne(locationV1);
            if (f == null) {
                String locationV1patch = locationV1.substring(1);
                f = gfs.findOne(locationV1patch);
            }
        } else if (serverLocation.contains("/public/") && (f = gfs.findOne(locationV1 = path.replace("/public/", "/home/null/"))) == null) {
            String locationV1patch = "/" + locationV1;
            f = gfs.findOne(locationV1patch);
        }
        return f;
    }

    protected List<GridFSDBFile> patchRemoteDirPathVersion1(String bucket, GridFS gfs, BasicDBObject query, List<GridFSDBFile> list) {
        List<GridFSDBFile> patchList = null;
        if (bucket.contains("/home/null/")) {
            String locationV2 = bucket.replace("/home/null/", "/public/");
            BasicDBObject queryPatch = new BasicDBObject();
            queryPatch.put("dir", locationV2);
            patchList = gfs.find(queryPatch);
        } else if (bucket.contains("/public/")) {
            String locationV1 = bucket.replace("/public/", "/home/null/");
            BasicDBObject queryPatch = new BasicDBObject();
            queryPatch.put("dir", locationV1);
            patchList = gfs.find(queryPatch);
            String locationV1patch = "/" + locationV1;
            queryPatch = new BasicDBObject();
            queryPatch.put("dir", locationV1patch);
            List<GridFSDBFile> patchList2 = gfs.find(queryPatch);
            if (patchList2 != null && !patchList2.isEmpty()) {
                if (patchList != null) {
                    patchList.addAll(patchList2);
                } else {
                    patchList = patchList2;
                }
            }
        }
        if (patchList != null && !patchList.isEmpty()) {
            list.addAll((Collection<GridFSDBFile>)patchList);
        }
        return list;
    }

    public BasicDBObject findMetaCollectionObject(String source) throws UnknownHostException {
        DBCollection fileCollection = this.getConnectionDB(this.dbName, false).getCollection("fs.files");
        BasicDBObject query = new BasicDBObject();
        BasicDBObject obj = null;
        query.put("filename", source);
        DBCursor cursor = fileCollection.find(query);
        if (cursor != null && !cursor.hasNext()) {
            query = new BasicDBObject();
            query.put("_id", new ObjectId(source));
            cursor = fileCollection.find(query);
        }
        if (cursor.hasNext()) {
            obj = (BasicDBObject)cursor.next();
            String path = (String)obj.get("filename");
            this.logger.debug("path found " + path);
        }
        return obj;
    }

    public DBObject findCollectionObject(DBCollection collection, BasicDBObject query) throws UnknownHostException {
        DBObject obj = null;
        obj = collection.findOne(query);
        return obj;
    }

    public DBCursor findCollectionObjects(DBCollection collection, BasicDBObject query) throws UnknownHostException {
        DBCursor cursor = collection.find(query);
        return cursor;
    }

    protected GridFSDBFile findGFSCollectionObject(ObjectId id) {
        return this.getGfs().find(id);
    }

    public DBObject executeQuery(DBCollection fileCollection, BasicDBObject query) throws UnknownHostException {
        DBCursor cursor;
        if (fileCollection == null) {
            fileCollection = this.getMetaDataCollection(this.getConnectionDB(this.dbName, false));
        }
        if ((cursor = fileCollection.find(query)).hasNext()) {
            return cursor.next();
        }
        return null;
    }

    protected String readByInputStream(MyFile resource, GridFSDBFile f, boolean isLock, int count) {
        String key = null;
        resource.setInputStream(new MongoInputStream(this.mongo, f.getInputStream()));
        return key;
    }

    protected String readByOutputStream(MyFile resource, GridFSDBFile f, boolean isLock, int count) throws IOException {
        String key = null;
        f.writeTo(resource.getOutputStream());
        resource.setOutputStream(null);
        f.save();
        return key;
    }

    protected String readByPath(MyFile resource, GridFSDBFile f, boolean isLock, int count) throws IOException {
        String key = null;
        try {
            File file = new File(resource.getLocalPath());
            f.writeTo(file);
            resource.setLocalPath(null);
        }
        catch (IOException e) {
            this.logger.error("Connection error. " + e.getMessage());
            if (count < 5) {
                this.logger.info(" Retry : #" + ++count);
                this.readByPath(resource, f, isLock, count);
            }
            this.close();
            this.logger.error("max number of retry completed ");
            throw new RuntimeException(e);
        }
        return key;
    }

    public GridFSInputFile createGFSFileObject(InputStream is, String writeConcern, String readPreference) throws UnknownHostException {
        GridFS gfs = new GridFS(this.getConnectionDB(this.dbName, true));
        GridFSInputFile f2 = gfs.createFile(is);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(String name, String writeConcern, String readPreference) throws IOException {
        GridFS gfs = new GridFS(this.getConnectionDB(this.dbName, true));
        GridFSInputFile f2 = gfs.createFile(name);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(File f, String writeConcern, String readPreference) {
        GridFS gfs = new GridFS(this.getConnectionDB(this.dbName, true));
        GridFSInputFile f2 = null;
        try {
            f2 = gfs.createFile(f);
        }
        catch (IOException e) {
            this.logger.error("problem in creation remote file " + f.getAbsolutePath());
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return f2;
    }

    public GridFSInputFile createGFSFileObject(byte[] b, String writeConcern, String readPreference) {
        GridFS gfs = new GridFS(this.getConnectionDB(this.dbName, true));
        GridFSInputFile f2 = gfs.createFile(b);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(InputStream is) throws UnknownHostException {
        GridFS gfs = new GridFS(this.getConnectionDB(null, false));
        GridFSInputFile f2 = gfs.createFile(is);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(String name) throws IOException {
        GridFS gfs = new GridFS(this.getConnectionDB(null, false));
        GridFSInputFile f2 = gfs.createFile(name);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(File f) {
        GridFS gfs = new GridFS(this.getConnectionDB(null, false));
        GridFSInputFile f2 = null;
        try {
            f2 = gfs.createFile(f);
        }
        catch (IOException e) {
            this.logger.error("problem in creation remote file " + f.getAbsolutePath());
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return f2;
    }

    public GridFSInputFile createGFSFileObject(byte[] b) {
        GridFS gfs = new GridFS(this.getConnectionDB(null, false));
        GridFSInputFile f2 = gfs.createFile(b);
        return f2;
    }

    protected List<GridFSDBFile> getFilesOnFolder(String folderPath) {
        GridFS gfs = new GridFS(this.getConnectionDB(this.dbName, false));
        BsonOperator bson = new BsonOperator(gfs);
        List<GridFSDBFile> list = bson.getFilesOnFolder(folderPath);
        this.close();
        return list;
    }

    protected List<GridFSDBFile> getOwnedFiles(String username) {
        GridFS gfs = new GridFS(this.getConnectionDB(this.dbName, false));
        BsonOperator bson = new BsonOperator(gfs);
        List<GridFSDBFile> list = bson.getOwnedFiles(username);
        this.close();
        return list;
    }

    public void buildDirTree(DBCollection meta, String dir) {
        String[] dirTree = dir.split("/");
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("/");
        for (int i = 1; i < dirTree.length; ++i) {
            BasicDBObject query = new BasicDBObject();
            query.put("name", dirTree[i]);
            query.put("dir", strBuff.toString());
            query.put("type", "dir");
            DBObject f = meta.findOne(query);
            if (f == null) {
                BasicDBObject newDir = new BasicDBObject();
                newDir.put("$set", new BasicDBObject().append("name", dirTree[i]).append("dir", strBuff.toString()).append("type", "dir"));
                if (this.memoryType != MemoryType.VOLATILE) {
                    meta.update(query, newDir, true, true, Costants.DEFAULT_WRITE_TYPE);
                } else {
                    meta.update(query, newDir, true, true);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" Create new  object with name: " + dirTree[i] + " dir: " + strBuff.toString() + " type= dir");
                }
            }
            strBuff.append(dirTree[i] + "/");
        }
    }

    protected String[] getServer() {
        return this.server;
    }

    public void setServer(String[] server) {
        this.server = server;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public void setMongo(MongoClient mongo) {
        this.mongo = mongo;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void printObject(DBObject obj) {
        Set<String> keys = obj.keySet();
        for (String key : keys) {
            this.logger.debug(" " + key + " " + obj.get(key));
        }
    }

    protected void saveGFSFileObject(GridFSInputFile f2) {
        f2.save();
    }

    protected void clean() {
        if (this.mongo != null) {
            this.mongo.close();
        }
        this.mongo = null;
        if (this.db != null) {
            this.db = null;
        }
    }

    public void close() {
        if (this.mongo != null) {
            this.mongo.close();
        }
        this.logger.info("Mongo has been closed");
        this.mongo = null;
        this.gfs = null;
        this.db = null;
    }

    public void removeGFSFile(GridFSDBFile f, ObjectId idF) {
        f.put("onDeleting", "true");
        f.save();
        this.getGfs().remove(idF);
    }

    protected void replaceGFSFile(GridFSDBFile f, ObjectId idToRemove) {
        f.put("onDeleting", "true");
        f.save();
        this.getGfs().remove(idToRemove);
    }

    public GridFS getGfs(String dbName, boolean readwritePreferences) {
        if (this.gfs == null) {
            this.gfs = this.db == null ? new GridFS(this.getConnectionDB(dbName, readwritePreferences)) : new GridFS(this.db);
        }
        return this.gfs;
    }

    public GridFS getGfs(boolean readwritePreferences) {
        return this.getGfs(this.dbName, readwritePreferences);
    }

    public GridFS getGfs() {
        return this.getGfs(true);
    }

    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    public void setMemoryType(MemoryType memoryType) {
        this.memoryType = memoryType;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName == null || dbName.isEmpty() ? "remotefs" : dbName;
    }

    public String getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
    }

    public String getReadPreference() {
        return this.readPreference;
    }

    public void setReadPreference(String readPreference) {
        this.readPreference = readPreference;
    }
}

