/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.core.endpoint.ServerFeatures;
import com.couchbase.client.core.endpoint.ServerFeaturesEvent;
import com.couchbase.client.core.endpoint.kv.AuthenticationException;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.channel.ChannelOutboundHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import com.couchbase.client.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.deps.io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;

public class KeyValueSelectBucketHandler
extends SimpleChannelInboundHandler<FullBinaryMemcacheResponse>
implements ChannelOutboundHandler {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueSelectBucketHandler.class);
    private final String bucket;
    private ChannelHandlerContext ctx;
    private ChannelPromise originalPromise;
    private boolean selectBucketEnabled;
    private static final byte SELECT_BUCKET_OPCODE = -119;
    private static final byte SUCCESS = 0;
    private static final byte ACCESS_ERROR = 36;

    public KeyValueSelectBucketHandler(String bucket) {
        this.bucket = bucket;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        if (this.selectBucketEnabled) {
            byte[] key = this.bucket.getBytes();
            short keyLength = (short)this.bucket.length();
            DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
            request.setOpcode((byte)-119);
            request.setKeyLength(keyLength);
            request.setTotalBodyLength(keyLength);
            this.ctx.writeAndFlush(request);
        } else {
            this.originalPromise.setSuccess();
            this.ctx.pipeline().remove(this);
            this.ctx.fireChannelActive();
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        switch (msg.getStatus()) {
            case 0: {
                this.originalPromise.setSuccess();
                ctx.pipeline().remove(this);
                ctx.fireChannelActive();
                break;
            }
            case 36: {
                this.originalPromise.setFailure(new AuthenticationException("Authentication failure on Select Bucket command"));
                break;
            }
            default: {
                this.originalPromise.setFailure(new AuthenticationException("Unhandled select bucket status: " + msg.getStatus()));
            }
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ServerFeaturesEvent) {
            this.selectBucketEnabled = ((ServerFeaturesEvent)evt).supportedFeatures().contains((Object)ServerFeatures.SELECT_BUCKET);
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.originalPromise = promise;
        ChannelPromise downPromise = ctx.newPromise();
        downPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<Void>>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess() && !KeyValueSelectBucketHandler.this.originalPromise.isDone()) {
                    KeyValueSelectBucketHandler.this.originalPromise.setFailure(future.cause());
                }
            }
        });
        ctx.connect(remoteAddress, localAddress, downPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

