/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class DefaultPortInfo
implements PortInfo {
    private final Map<ServiceType, Integer> ports = new HashMap<ServiceType, Integer>();
    private final Map<ServiceType, Integer> sslPorts = new HashMap<ServiceType, Integer>();
    private final NetworkAddress hostname;

    @JsonCreator
    public DefaultPortInfo(@JsonProperty(value="services") Map<String, Integer> services, @JsonProperty(value="hostname") String hostname) {
        try {
            this.hostname = hostname == null ? null : NetworkAddress.create(hostname);
        }
        catch (Exception e) {
            throw new CouchbaseException("Could not analyze hostname from config.", e);
        }
        boolean analyticsEnabled = Boolean.parseBoolean(System.getProperty("com.couchbase.analyticsEnabled", "false"));
        int analyticsPort = Integer.parseInt(System.getProperty("com.couchbase.analyticsPort", "8095"));
        int analyticsSslPort = Integer.parseInt(System.getProperty("com.couchbase.analyticsSslPort", "18095"));
        if (analyticsEnabled) {
            this.ports.put(ServiceType.ANALYTICS, analyticsPort);
            this.sslPorts.put(ServiceType.ANALYTICS, analyticsSslPort);
        }
        for (Map.Entry<String, Integer> entry : services.entrySet()) {
            String service = entry.getKey();
            int port = entry.getValue();
            if (service.equals("mgmt")) {
                this.ports.put(ServiceType.CONFIG, port);
                continue;
            }
            if (service.equals("capi")) {
                this.ports.put(ServiceType.VIEW, port);
                continue;
            }
            if (service.equals("kv")) {
                this.ports.put(ServiceType.BINARY, port);
                continue;
            }
            if (service.equals("kvSSL")) {
                this.sslPorts.put(ServiceType.BINARY, port);
                continue;
            }
            if (service.equals("capiSSL")) {
                this.sslPorts.put(ServiceType.VIEW, port);
                continue;
            }
            if (service.equals("mgmtSSL")) {
                this.sslPorts.put(ServiceType.CONFIG, port);
                continue;
            }
            if (service.equals("n1ql")) {
                this.ports.put(ServiceType.QUERY, port);
                continue;
            }
            if (service.equals("n1qlSSL")) {
                this.sslPorts.put(ServiceType.QUERY, port);
                continue;
            }
            if (!service.equals("fts")) continue;
            this.ports.put(ServiceType.SEARCH, port);
        }
    }

    @Override
    public Map<ServiceType, Integer> ports() {
        return this.ports;
    }

    @Override
    public Map<ServiceType, Integer> sslPorts() {
        return this.sslPorts;
    }

    @Override
    public NetworkAddress hostname() {
        return this.hostname;
    }

    public String toString() {
        return "DefaultPortInfo{ports=" + this.ports + ", sslPorts=" + this.sslPorts + ", hostname='" + this.hostname + '\'' + '}';
    }
}

