/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.env.ConfigParserEnvironment;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JacksonInject;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultMemcachedBucketConfig
extends AbstractBucketConfig
implements MemcachedBucketConfig {
    private final long rev;
    private final TreeMap<Long, NodeInfo> ketamaNodes;
    private final ConfigParserEnvironment env;

    @JsonCreator
    public DefaultMemcachedBucketConfig(@JacksonInject(value="env") ConfigParserEnvironment env, @JsonProperty(value="rev") long rev, @JsonProperty(value="name") String name, @JsonProperty(value="uri") String uri, @JsonProperty(value="streamingUri") String streamingUri, @JsonProperty(value="nodes") List<NodeInfo> nodeInfos, @JsonProperty(value="nodesExt") List<PortInfo> portInfos, @JsonProperty(value="bucketCapabilities") List<BucketCapabilities> bucketCapabilities) {
        super(name, BucketNodeLocator.KETAMA, uri, streamingUri, nodeInfos, portInfos, bucketCapabilities);
        this.env = env;
        this.rev = rev;
        this.ketamaNodes = new TreeMap();
        this.populateKetamaNodes();
    }

    @Override
    public boolean tainted() {
        return false;
    }

    @Override
    public long rev() {
        return this.rev;
    }

    @Override
    public BucketType type() {
        return BucketType.MEMCACHED;
    }

    @Override
    public SortedMap<Long, NodeInfo> ketamaNodes() {
        return this.ketamaNodes;
    }

    private void populateKetamaNodes() {
        for (NodeInfo node : this.nodes()) {
            if (!node.services().containsKey((Object)ServiceType.BINARY)) continue;
            for (int i = 0; i < 40; ++i) {
                try {
                    MessageDigest md5 = MessageDigest.getInstance("MD5");
                    md5.update(this.env.memcachedHashingStrategy().hash(node, i).getBytes(CharsetUtil.UTF_8));
                    byte[] digest = md5.digest();
                    for (int j = 0; j < 4; ++j) {
                        Long key = (long)(digest[3 + j * 4] & 0xFF) << 24 | (long)(digest[2 + j * 4] & 0xFF) << 16 | (long)(digest[1 + j * 4] & 0xFF) << 8 | (long)(digest[j * 4] & 0xFF);
                        this.ketamaNodes.put(key, node);
                    }
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Could not populate ketama nodes.", e);
                }
            }
        }
    }

    @Override
    public NetworkAddress nodeForId(byte[] id) {
        long hash = DefaultMemcachedBucketConfig.calculateKetamaHash(id);
        if (!this.ketamaNodes.containsKey(hash)) {
            SortedMap<Long, NodeInfo> tailMap = this.ketamaNodes.tailMap(hash);
            hash = tailMap.isEmpty() ? this.ketamaNodes.firstKey().longValue() : tailMap.firstKey().longValue();
        }
        return this.ketamaNodes.get(hash).hostname();
    }

    @Override
    public boolean hasFastForwardMap() {
        return false;
    }

    private static long calculateKetamaHash(byte[] key) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(key);
            byte[] digest = md5.digest();
            long rv = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
            return rv & 0xFFFFFFFFL;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not encode ketama hash.", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultMemcachedBucketConfig{");
        sb.append("rev=").append(this.rev);
        sb.append(", ketamaNodes=").append(this.ketamaNodes);
        sb.append('}');
        return sb.toString();
    }
}

