/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend.util;

import com.mongodb.MongoClient;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class MongoOutputStream
extends ProxyOutputStream {
    private MongoClient mongo;
    private boolean closed;

    public MongoOutputStream(MongoClient mongo, OutputStream proxy) {
        super(proxy);
        this.mongo = mongo;
    }

    @Override
    public void write(int idx) throws IOException {
        this.out.write(idx);
    }

    @Override
    public void write(byte[] bts) throws IOException {
        this.out.write(bts);
    }

    @Override
    public void write(byte[] bts, int st, int end) throws IOException {
        this.out.write(bts, st, end);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            try {
                super.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mongo.close();
            this.setClosed(true);
        }
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

