/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv.subdoc.multi;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.AbstractKeyValueRequest;
import com.couchbase.client.core.message.kv.subdoc.BinarySubdocMultiLookupRequest;
import com.couchbase.client.core.message.kv.subdoc.multi.LookupCommand;
import com.couchbase.client.core.message.kv.subdoc.multi.SubMultiLookupDocOptionsBuilder;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.CompositeByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.util.Arrays;
import java.util.List;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class SubMultiLookupRequest
extends AbstractKeyValueRequest
implements BinarySubdocMultiLookupRequest {
    private final List<LookupCommand> commands;
    private final ByteBuf encoded;
    private byte docFlags;

    public SubMultiLookupRequest(String key, String bucket, SubMultiLookupDocOptionsBuilder docOptionsBuilder, LookupCommand ... commands) {
        super(key, bucket);
        if (commands == null) {
            throw new NullPointerException("At least one lookup command is necessary");
        }
        this.commands = Arrays.asList(commands);
        this.encoded = SubMultiLookupRequest.encode(this.commands);
        if (docOptionsBuilder.accessDeleted()) {
            this.docFlags = (byte)(this.docFlags | 4);
        }
    }

    public SubMultiLookupRequest(String key, String bucket, LookupCommand ... commands) {
        this(key, bucket, SubMultiLookupDocOptionsBuilder.builder(), commands);
    }

    private static ByteBuf encode(List<LookupCommand> commands) {
        CompositeByteBuf compositeBuf = Unpooled.compositeBuffer(commands.size());
        for (LookupCommand command : commands) {
            byte[] pathBytes = command.path().getBytes(CharsetUtil.UTF_8);
            short pathLength = (short)pathBytes.length;
            ByteBuf commandBuf = Unpooled.buffer(4 + pathLength);
            commandBuf.writeByte(command.opCode());
            if (command.xattr()) {
                commandBuf.writeByte(4);
            } else {
                commandBuf.writeByte(0);
            }
            commandBuf.writeShort(pathLength);
            commandBuf.writeBytes(pathBytes);
            compositeBuf.addComponent(commandBuf);
            compositeBuf.writerIndex(compositeBuf.writerIndex() + commandBuf.readableBytes());
        }
        return compositeBuf;
    }

    @Override
    public List<LookupCommand> commands() {
        return this.commands;
    }

    @Override
    public ByteBuf content() {
        return this.encoded;
    }

    @Override
    public byte docFlags() {
        return this.docFlags;
    }
}

