/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lock
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String localPath;
    private String remotePath;
    private OutputStream os;

    public Lock(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" DOWNLOAD " + myFile.getRemotePath() + " in bucket: " + this.bucket);
        }
        String unlockKey = null;
        try {
            unlockKey = this.get(myFile, true);
        }
        catch (Exception e) {
            TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
            TransportManager tm = tmf.getTransport(this.backendType, myFile.getGcubeMemoryType());
            tm.close();
            throw new RemoteBackendException(" Error in lock operation ", e.getCause());
        }
        return unlockKey;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String bucketName = null;
        if (remotePath.length() < 23 || remotePath.contains("/")) {
            this.localPath = file.getLocalPath();
            this.remotePath = remotePath;
            bucketName = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        } else {
            bucketName = remotePath;
        }
        this.bucket = bucketName;
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

